/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.tileentity.PedestalTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PedestalBlock
extends BaseTileEntityBlock {
    public static final VoxelShape PEDESTAL_SHAPE = VoxelShapeBuilder.builder().cuboid(3.0, 2.0, 3.0, 13.0, 14.0, 13.0).cuboid(1.0, 0.0, 1.0, 15.0, 2.0, 15.0).cuboid(2.0, 14.0, 2.0, 14.0, 16.0, 14.0).build();

    public PedestalBlock() {
        super(SoundType.METAL, 5.0f, 10.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PedestalTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tile;
            BaseItemStackHandler inventory = pedestal.getInventory();
            ItemStack input = inventory.getStackInSlot(0);
            ItemStack held = player.getItemInHand(hand);
            if (input.isEmpty() && !held.isEmpty()) {
                inventory.setStackInSlot(0, StackHelper.withSize((ItemStack)held, (int)1, (boolean)false));
                player.setItemInHand(hand, StackHelper.shrink((ItemStack)held, (int)1, (boolean)false));
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!input.isEmpty()) {
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), input);
                item.setNoPickUpDelay();
                level.addFreshEntity((Entity)item);
                inventory.setStackInSlot(0, ItemStack.EMPTY);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)pedestal.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PEDESTAL_SHAPE;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return BlockHelper.getRedstoneSignalFromInventory((BlockEntity)level.getBlockEntity(pos));
    }
}

