/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class TeleportToTeam
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("teleport_to_team"));

    public TeleportToTeam() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        EasyNetwork network = SkyGUIs.getNetwork();
        Level level = player.level();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeam(msg.team);
        if (team == null) {
            return;
        }
        if (!PermissionManager.INSTANCE.mayBypassLimitation((Player)player) && !PermissionsConfig.Teleports.teleportationDimensions.test(level.dimension().location())) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_TELEPORTATION_NOT_ALLOWED_DIMENSION);
            return;
        }
        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_ACROSS_DIMENSIONS) && level != data.getLevel()) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_TELEPORT_ACROSS_DIMENSIONS);
            return;
        }
        if (!PermissionManager.INSTANCE.mayBypassLimitation((Player)player) && PermissionsConfig.Teleports.disallowTeleportationDuringFalling && player.fallDistance > 1.0f) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_PREVENT_WHILE_FALLING);
            return;
        }
        switch (msg.teleportType) {
            case SPAWN: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_SPAWN)) break;
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_TELEPORT_SPAWN);
                return;
            }
            case HOME: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_HOME)) break;
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_TELEPORT_HOME);
                return;
            }
            case VISIT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_VISITING_ISLAND)) break;
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_TEAM_VISIT);
                return;
            }
        }
        if (!PermissionManager.INSTANCE.mayBypassLimitation((Player)player) && !data.getOrCreateMetaInfo((Player)player).canTeleport(msg.teleportType, level.getGameTime())) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_COOLDOWN.apply(RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.Cooldowns.spawnCooldown - (level.getGameTime() - data.getOrCreateMetaInfo((Player)player).getLastTeleport(SkyMeta.TeleportType.SPAWN))))));
            return;
        }
        block5 : switch (msg.teleportType) {
            case SPAWN: {
                switch (SkyblockHooks.onTeleportToSpawn((ServerPlayer)player, (Team)team)) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_TELEPORT_TO_SPAWN);
                        return;
                    }
                    case DEFAULT: {
                        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_SPAWN)) {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_TELEPORT_SPAWN);
                            return;
                        }
                        break block5;
                    }
                }
                break;
            }
            case HOME: {
                switch (SkyblockHooks.onTeleportHome((ServerPlayer)player, (Team)team)) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_TELEPORT_HOME);
                        return;
                    }
                    case DEFAULT: {
                        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_HOME)) {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_TELEPORT_HOME);
                            return;
                        }
                        break block5;
                    }
                }
                break;
            }
            case VISIT: {
                switch (SkyblockHooks.onTeleportToVisit((ServerPlayer)player, (Team)team)) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_VISIT_TEAM);
                        return;
                    }
                    case DEFAULT: {
                        if (team.hasPlayer((Player)player)) {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_VISIT_OWN_TEAM);
                            return;
                        }
                        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_VISITING_ISLAND)) {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_TEAM_VISIT);
                            return;
                        }
                        if (team.allowsVisits()) break;
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_VISIT_TEAM);
                        return;
                    }
                }
                break;
            }
        }
        if (!PermissionManager.INSTANCE.mayBypassLimitation((Player)player)) {
            data.getOrCreateMetaInfo((Player)player).setLastTeleport(msg.teleportType, level.getGameTime());
        }
        WorldUtil.teleportToIsland((ServerPlayer)player, (Team)team);
        network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)Component.empty());
    }

    public record Message(UUID team, SkyMeta.TeleportType teleportType) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeUUID(msg.team);
            buffer.writeEnum((Enum)msg.teleportType);
        }, buffer -> new Message(buffer.readUUID(), (SkyMeta.TeleportType)buffer.readEnum(SkyMeta.TeleportType.class)));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

