/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockManageTeamEvent;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class RemoveSpawns
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("remove_spawns"));

    public RemoveSpawns() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        EasyNetwork network = SkyGUIs.getNetwork();
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return;
        }
        if (level != level.getServer().getLevel(SpawnConfig.spawnDimension)) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_WRONG_POSITION);
            return;
        }
        int failedRemovals = 0;
        for (BlockPos pos : msg.positions()) {
            SkyblockManageTeamEvent.Result result = SkyblockHooks.onRemoveSpawn((ServerPlayer)player, (Team)team, (BlockPos)pos);
            switch (result) {
                case DENY: {
                    ++failedRemovals;
                    break;
                }
                case DEFAULT: {
                    if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.EDIT_SPAWNS)) break;
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_MODIFY_SPAWNS);
                    return;
                }
            }
            if (team.removePossibleSpawn(pos)) continue;
            ++failedRemovals;
        }
        if (failedRemovals >= msg.positions().size()) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("removed_spawns.failed", new Object[0]));
            return;
        }
        network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)ComponentBuilder.text("removed_spawns", msg.positions().size() - failedRemovals, msg.positions().size()));
    }

    public record Message(Set<BlockPos> positions) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeVarInt(msg.positions.size());
            msg.positions.forEach(arg_0 -> ((RegistryFriendlyByteBuf)buffer).writeBlockPos(arg_0));
        }, buffer -> {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            int size = buffer.readVarInt();
            for (int i = 0; i < size; ++i) {
                positions.add(buffer.readBlockPos());
            }
            return new Message(positions);
        });

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

