/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockManageTeamEvent;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class EditSpawns
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("edit_spawns"));

    public EditSpawns() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        EasyNetwork network = SkyGUIs.getNetwork();
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return;
        }
        switch (msg.editSpawnsType.ordinal()) {
            case 0: {
                Direction vanillaDirection = switch (msg.direction) {
                    default -> throw new MatchException(null, null);
                    case WorldUtil.SpawnDirection.NORTH -> Direction.NORTH;
                    case WorldUtil.SpawnDirection.SOUTH -> Direction.SOUTH;
                    case WorldUtil.SpawnDirection.EAST -> Direction.EAST;
                    case WorldUtil.SpawnDirection.WEST -> Direction.WEST;
                };
                SkyblockManageTeamEvent.Result result = (SkyblockManageTeamEvent.Result)SkyblockHooks.onAddSpawn((ServerPlayer)player, (Team)team, (BlockPos)msg.pos, (Direction)vanillaDirection).getLeft();
                switch (result) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_CREATE_SPAWN);
                        return;
                    }
                    case DEFAULT: {
                        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.EDIT_SPAWNS)) {
                            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_MODIFY_SPAWNS);
                            return;
                        }
                        Vec3i templateSize = TemplateData.get((ServerLevel)level).getConfiguredTemplate().getTemplate().getSize();
                        BlockPos.MutableBlockPos center = team.getIsland().getCenter().mutable();
                        center.offset(templateSize.getX() / 2, templateSize.getY() / 2, templateSize.getZ() / 2);
                        if (msg.pos.closerThan((Vec3i)center, (double)PermissionsConfig.Spawns.range)) break;
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_POSITION_TOO_FAR_AWAY);
                        return;
                    }
                }
                team.addPossibleSpawn(msg.pos, msg.direction);
                network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)SkyComponents.SUCCESS_SPAWN_ADDED.apply((Object)msg.pos.getX(), (Object)msg.pos.getY(), (Object)msg.pos.getZ()));
                break;
            }
            case 1: {
                if (level != level.getServer().getLevel(SpawnConfig.spawnDimension)) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_WRONG_POSITION);
                    return;
                }
                SkyblockManageTeamEvent.Result result = SkyblockHooks.onRemoveSpawn((ServerPlayer)player, (Team)team, (BlockPos)msg.pos);
                switch (result) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_MODIFY_SPAWNS0);
                        return;
                    }
                    case DEFAULT: {
                        if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.EDIT_SPAWNS)) break;
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_MODIFY_SPAWNS);
                        return;
                    }
                }
                if (!team.removePossibleSpawn(msg.pos)) {
                    MutableComponent answer = SkyComponents.ERROR_REMOVE_SPAWN0;
                    if (team.getPossibleSpawns().size() <= 1) {
                        answer.append(" ").append((Component)SkyComponents.ERROR_REMOVE_SPAWN1);
                    }
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)answer);
                    return;
                }
                network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)SkyComponents.SUCCESS_SPAWN_REMOVED.apply((Object)msg.pos.getX(), (Object)msg.pos.getY(), (Object)msg.pos.getZ()));
                break;
            }
            case 2: {
                switch (SkyblockHooks.onResetSpawns((ServerPlayer)player, (Team)team)) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_MODIFY_SPAWNS0);
                        return;
                    }
                    case DEFAULT: {
                        if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.EDIT_SPAWNS)) break;
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_MODIFY_SPAWNS);
                        return;
                    }
                }
                team.setPossibleSpawns((Collection)team.getDefaultPossibleSpawns());
            }
        }
    }

    public record Message(Type editSpawnsType, BlockPos pos, WorldUtil.SpawnDirection direction) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeEnum((Enum)msg.editSpawnsType);
            buffer.writeBlockPos(msg.pos);
            buffer.writeEnum((Enum)msg.direction);
        }, buffer -> new Message((Type)buffer.readEnum(Type.class), buffer.readBlockPos(), (WorldUtil.SpawnDirection)buffer.readEnum(WorldUtil.SpawnDirection.class)));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static enum Type {
        ADD,
        REMOVE,
        RESET;

    }
}

