/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.edit;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import de.melanx.skyguis.client.screen.base.list.PlayerListScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class InvitablePlayersScreen
extends PlayerListScreen {
    private static final Component INVITE = ComponentBuilder.text("invite", new Object[0]);
    private final Team team;
    private final BaseScreen prev;
    private Button inviteButton;
    private Checkbox selectAll;
    private int selectedAmount = 0;

    public InvitablePlayersScreen(Team team, BaseScreen prev) {
        super((Component)Component.literal((String)team.getName()), InvitablePlayersScreen.getInvitablePlayers(team), 200, 230, new ListScreen.ScrollbarInfo(180, 10, 210), new ListScreen.RenderAreaInfo(10, 50, 160));
        this.team = team;
        this.prev = prev;
    }

    @Override
    protected void init() {
        this.inviteButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)INVITE, button -> {
            Set inviteIds = this.getSelectedValues().stream().map(GameProfile::getId).collect(Collectors.toSet());
            Minecraft.getInstance().pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, (Component)ComponentBuilder.text("you_sure_invite", inviteIds.size()), () -> {
                SkyGUIs.getNetwork().handleInvitePlayers(this.team.getName(), inviteIds);
                Minecraft.getInstance().setScreen((Screen)new InvitablePlayersScreen(this.team, this.prev));
            }, () -> Minecraft.getInstance().setScreen((Screen)this)));
        }).bounds(this.x(10), this.y(200), 40, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.getInstance().setScreen((Screen)this.prev)).bounds(this.x(57), this.y(200), 115, 20).build());
        this.selectAll = (Checkbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(9), this.y(32), 14, false, this.allSelected() ? UNSELECT_ALL : SELECT_ALL, (checkbox, value) -> this.selectAll(value)));
        super.init();
        this.updateButtons();
    }

    @Override
    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, (Component)ComponentBuilder.text("selected_amount", this.selectedAmount), this.x(28), this.y(35), Color.DARK_GRAY.getRGB(), false);
    }

    public void updateButtons() {
        Set selectedIds = this.getSelectedValues().stream().map(GameProfile::getId).collect(Collectors.toSet());
        this.inviteButton.active = !selectedIds.isEmpty();
        this.selectAll.selected = this.allSelected();
        this.selectedAmount = selectedIds.size();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean ret = super.mouseClicked(mouseX, mouseY, button);
        this.updateButtons();
        return ret;
    }

    private static Set<UUID> getInvitablePlayers(Team team) {
        HashSet ids = Sets.newHashSet();
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        LocalPlayer player = minecraft.player;
        if (level == null || player == null) {
            return ids;
        }
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        for (UUID id : player.connection.getOnlinePlayerIds()) {
            if (data.hasPlayerTeam(id) || data.hasInviteFrom(team, id)) continue;
            ids.add(id);
        }
        return ids;
    }
}

