/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.edit;

import com.google.common.collect.Lists;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import de.melanx.skyguis.client.screen.base.list.TeamListScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.client.widget.sizable.SizableButton;
import de.melanx.skyguis.network.handler.AnswerInvitation;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.moddingx.libx.impl.config.gui.screen.widget.TextWidget;
import org.moddingx.libx.screen.Panel;

public class HandleInvitationsScreen
extends TeamListScreen {
    public static final Component TITLE = ComponentBuilder.title("invitations", new Object[0]);

    public HandleInvitationsScreen() {
        super(TITLE, HandleInvitationsScreen.collectInvited(), 200, 230, new ListScreen.ScrollbarInfo(180, 10, 210), new ListScreen.RenderAreaInfo(10, 50, 160));
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new HandleInvitationsScreen());
    }

    @Override
    protected void fillWidgets() {
        Minecraft minecraft = Minecraft.getInstance();
        for (int i = 0; i < this.values.size(); ++i) {
            this.renderArea.addRenderableWidget2(new JoinTeamWidget((Team)this.values.get(i), this, 0, 14 * i, 100, 12, team -> minecraft.pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, (Component)ComponentBuilder.text("you_sure_join", team.getName()), () -> {
                SkyGUIs.getNetwork().handleInvitationAnswer(team.getName(), AnswerInvitation.Type.ACCEPT);
                minecraft.setScreen(null);
            })), team -> minecraft.pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, (Component)ComponentBuilder.text("you_sure_ignore", team.getName()), () -> {
                SkyGUIs.getNetwork().handleInvitationAnswer(team.getName(), AnswerInvitation.Type.IGNORE);
                Minecraft.getInstance().setScreen((Screen)new HandleInvitationsScreen());
            }))));
        }
    }

    private static List<Team> collectInvited() {
        Minecraft minecraft = Minecraft.getInstance();
        SkyblockSavedData data = SkyblockSavedData.get((Level)minecraft.level);
        List invites = data.getInvites(minecraft.player.getGameProfile().getId());
        if (invites == null) {
            return Lists.newArrayList();
        }
        return invites.stream().map(arg_0 -> ((SkyblockSavedData)data).getTeam(arg_0)).collect(Collectors.toList());
    }

    private static class JoinTeamWidget
    extends Panel {
        public JoinTeamWidget(Team team, Screen screen, int x, int y, int width, int height, Consumer<Team> onJoin, Consumer<Team> onIgnore) {
            super(x, y, width, height);
            this.addRenderableWidget((GuiEventListener)SizableButton.builder((Component)ComponentBuilder.button("join", new Object[0]), button -> onJoin.accept(team)).bounds(0, 0, 30, height).build());
            this.addRenderableWidget((GuiEventListener)SizableButton.builder((Component)ComponentBuilder.button("ignore", new Object[0]), button -> onIgnore.accept(team)).bounds(33, 0, 30, height).build());
            this.addRenderableOnly((Renderable)new TextWidget(66, 0, Math.min(width, TextHelper.stringLength(team.getName())), height, (Component)Component.literal((String)team.getName()), (List)Lists.newArrayList()));
        }
    }
}

