/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen;

import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.template.TemplatePreview;
import de.melanx.skyblockbuilder.template.TemplatePreviewRenderer;
import de.melanx.skyblockbuilder.util.NameGenerator;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class CreateTeamScreen
extends BaseScreen {
    private static final Component NAME_COMPONENT = ComponentBuilder.text("name", new Object[0]);
    private static final Component TEMPLATE_COMPONENT = ComponentBuilder.raw("template", new Object[0]);
    private static final Component SETTINGS_COMPONENT = ComponentBuilder.text("settings", new Object[0]);
    private static final Component CREATE = ComponentBuilder.button("create", new Object[0]);
    private static final Component ABORT = ComponentBuilder.button("abort", new Object[0]);
    private static final Component TITLE = ComponentBuilder.title("create_team", new Object[0]);
    private static final Component ALLOW_VISITS = ComponentBuilder.text("allow_visits", new Object[0]);
    private static final Component ALLOW_REQUESTS = ComponentBuilder.text("allow_requests", new Object[0]);
    private final transient Map<String, TemplatePreviewRenderer> structureCache = new HashMap<String, TemplatePreviewRenderer>();
    private final List<String> templates = TemplateLoader.getTemplateNames();
    private String currTemplate;
    private EditBox name;
    private int currIndex = 0;
    private boolean enableTooltip;
    private Button templateButton;
    private SizeableCheckbox allowVisits;
    private SizeableCheckbox allowJoinRequests;

    public CreateTeamScreen() {
        super(TITLE, 200, 147);
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new CreateTeamScreen());
    }

    protected void init() {
        this.structureCache.clear();
        this.name = new EditBox(this.font, this.x(66), this.y(30), 120, 20, (Component)Component.empty());
        this.name.setMaxLength(Short.MAX_VALUE);
        this.name.setValue(this.name.getValue());
        this.name.setMaxLength(64);
        this.addRenderableWidget((GuiEventListener)this.name);
        if (this.templates.isEmpty()) {
            Minecraft.getInstance().setScreen(null);
            Minecraft.getInstance().player.sendSystemMessage((Component)ComponentBuilder.text("empty_templates", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}));
            return;
        }
        Component shortened = this.setCurrentTemplateAndGetShortenedName();
        this.templateButton = Button.builder((Component)shortened, button -> {
            this.currIndex = Mth.positiveModulo((int)(this.currIndex + (Screen.hasShiftDown() ? -1 : 1)), (int)this.templates.size());
            Component s = this.setCurrentTemplateAndGetShortenedName();
            button.setMessage(s);
            this.updateTemplateButton();
        }).bounds(this.x(65), this.y(60), 122, 20).build();
        this.allowVisits = new SizeableCheckbox(this.x(65), this.y(85), 10, false);
        this.allowJoinRequests = new SizeableCheckbox(this.x(65), this.y(100), 10, false);
        this.addRenderableWidget((GuiEventListener)this.allowVisits);
        this.addRenderableWidget((GuiEventListener)this.allowJoinRequests);
        this.updateTemplateButton();
        if (this.templates.size() == 1) {
            this.templateButton.active = false;
        }
        this.currTemplate = this.templates.get(this.currIndex);
        this.addRenderableWidget((GuiEventListener)this.templateButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CREATE, button -> {
            if (this.name.getValue().isBlank()) {
                this.name.setFocused(true);
                this.name.setValue(NameGenerator.randomName((Random)new Random()));
            } else {
                SkyGUIs.getNetwork().handleCreateTeam(this.name.getValue().strip(), this.currTemplate, this.allowVisits.selected, this.allowJoinRequests.selected);
            }
        }).bounds(this.x(27), this.y(116), 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ABORT, button -> this.onClose()).bounds(this.x(106), this.y(116), 60, 20).build());
    }

    private Component setCurrentTemplateAndGetShortenedName() {
        String orig = this.templates.get(this.currIndex);
        ConfiguredTemplate configuredTemplate = TemplateLoader.getConfiguredTemplate((String)orig);
        if (configuredTemplate == null) {
            throw new IllegalStateException("Templates not synced between client and server: " + orig);
        }
        Component nameComponent = configuredTemplate.getNameComponent();
        String s = TextHelper.shorten(this.font, nameComponent.getString(), 110);
        String desc = configuredTemplate.getDescriptionComponent().getString();
        this.enableTooltip = !s.equals(nameComponent.getString()) || !desc.isBlank();
        this.currTemplate = orig;
        return Component.literal((String)s).setStyle(nameComponent.getStyle());
    }

    @Override
    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
        guiGraphics.drawString(this.font, NAME_COMPONENT, this.x(10), this.y(37), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, TEMPLATE_COMPONENT, this.x(10), this.y(67), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, SETTINGS_COMPONENT, this.x(10), this.y(92), Color.DARK_GRAY.getRGB(), false);
        if (!this.structureCache.containsKey(this.currTemplate)) {
            SkyGUIs.getNetwork().requestTemplateFromServer(this.currTemplate);
            this.structureCache.put(this.currTemplate, null);
            return;
        }
        TemplatePreviewRenderer renderer = this.structureCache.get(this.currTemplate);
        if (renderer != null) {
            renderer.render(guiGraphics);
        }
        float scale = 0.9f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.drawString(this.font, ALLOW_VISITS, (int)((float)this.x(82) / scale), (int)((float)this.y(87) / scale), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, ALLOW_REQUESTS, (int)((float)this.x(82) / scale), (int)((float)this.y(102) / scale), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.pose().scale(1.25f, 1.25f, 1.25f);
        guiGraphics.pose().popPose();
    }

    public void addStructureToCache(String name, ConfiguredTemplate template) {
        this.structureCache.put(name, new TemplatePreviewRenderer(new TemplatePreview(template), new TemplatePreviewRenderer.Area((int)((double)this.x(0) * 0.05), 0, (int)((double)this.x(0) * 0.9), this.height)));
    }

    public void updateTemplateButton() {
        if (this.enableTooltip) {
            ConfiguredTemplate configuredTemplate = TemplateLoader.getConfiguredTemplate((String)this.currTemplate);
            if (configuredTemplate == null) {
                throw new IllegalStateException("Template does not exist: " + this.currTemplate);
            }
            MutableComponent nameComponent = configuredTemplate.getNameComponent().copy();
            MutableComponent descComponent = configuredTemplate.getDescriptionComponent().copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
            this.templateButton.setTooltip(Tooltip.create((Component)nameComponent.append("\n").append((Component)descComponent)));
        }
    }
}

