/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mekanism.client.screen;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.mekanism.client.container.ChemicalHatchContainer;
import es.degrassi.mmreborn.mekanism.client.util.ChemicalRenderer;
import es.degrassi.mmreborn.mekanism.common.entity.base.ChemicalTankEntity;
import java.util.ArrayList;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ChemicalHatchScreen
extends BaseScreen<ChemicalHatchContainer, ChemicalTankEntity> {
    public ChemicalHatchScreen(ChemicalHatchContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((ContainerBase)pMenu, pPlayerInventory, pTitle);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"modular_machinery_reborn", (String)"textures/gui/guibar.png");
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        ChemicalStack content = ((ChemicalTankEntity)this.entity).getTank().getStack();
        guiGraphics.pose().pushPose();
        ChemicalRenderer.renderChemical(guiGraphics, this.leftPos + 15, this.topPos + 10, 20, 61, content, ((ChemicalTankEntity)this.entity).getTank().getCapacity());
        guiGraphics.pose().popPose();
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int offsetX = (this.width - this.getXSize()) / 2;
        int offsetZ = (this.height - this.getYSize()) / 2;
        if (x >= 15 + offsetX && x <= 35 + offsetX && y >= 10 + offsetZ && y <= 71 + offsetZ) {
            long amt;
            ArrayList text = Lists.newArrayList();
            ChemicalStack content = ((ChemicalTankEntity)this.entity).getTank().getStack();
            if (content.getAmount() <= 0L) {
                text.add(Component.translatable((String)"tooltip.chemicalhatch.empty"));
                amt = 0L;
            } else {
                text.add(content.getTextComponent());
                amt = content.getAmount();
            }
            text.add(Component.translatable((String)"tooltip.chemicalhatch.tank", (Object[])new Object[]{String.valueOf(amt), String.valueOf(((ChemicalTankEntity)this.entity).getTank().getCapacity())}));
            Font font = Minecraft.getInstance().font;
            guiGraphics.renderTooltip(font, text.stream().map(Component::getVisualOrderText).toList(), x, y);
        }
    }
}

