/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.base.itemhandlers;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;
import vapourdrive.vapourware.VapourWare;

public class OutputHandler
extends ItemStackHandler {
    final BlockEntity tile;

    public OutputHandler(BlockEntity tile, int size) {
        this.tile = tile;
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    protected void onContentsChanged(int slot) {
        this.tile.setChanged();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean internal) {
        return internal ? this.internalInsertItem(slot, stack, simulate) : stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        VapourWare.debugLog("Insert Item");
        if (VapourWare.isDebugMode()) {
            VapourWare.debugLog("trying to debug insert into output.");
            return this.internalInsertItem(slot, stack, simulate);
        }
        return this.insertItem(slot, stack, simulate, false);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public ItemStack internalInsertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.stacks.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public boolean isFull() {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.getCount() >= this.getStackLimit(i, stack)) continue;
            return false;
        }
        return true;
    }

    public int getEmptySlots() {
        int count = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.getStackInSlot(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }
}

