/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.base;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import vapourdrive.vapourware.shared.base.AbstractBaseMachineMenu;
import vapourdrive.vapourware.shared.base.slots.AbstractMachineSlot;
import vapourdrive.vapourware.shared.utils.CompUtils;
import vapourdrive.vapourware.shared.utils.DeferredComponent;

public class AbstractBaseMachineScreen<T extends AbstractBaseMachineMenu>
extends AbstractContainerScreen<T> {
    protected final AbstractBaseMachineMenu machineMenu;
    protected final ResourceLocation GUI;
    protected int FUEL_XPOS = 12;
    protected int FUEL_YPOS = 8;
    protected int FUEL_ICONX = 176;
    protected int FUEL_ICONY = 0;
    protected int FUEL_HEIGHT = 46;
    final int FUEL_WIDTH = 8;
    protected int INFO_XPOS = 158;
    protected int INFO_YPOS = 6;
    final int INFO_ICONX = 184;
    final int INFO_ICONY = 0;
    final int INFO_HEIGHT = 12;
    final int INFO_WIDTH = 12;
    protected final DeferredComponent comp;
    protected final boolean STACK_INFO_SIDEWAYS;
    protected final DecimalFormat df = new DecimalFormat("#,###");

    public AbstractBaseMachineScreen(T menu, Inventory inv, Component name, DeferredComponent compIn, boolean stackInfoSideways) {
        super(menu, inv, name);
        this.machineMenu = menu;
        this.titleLabelY = -10;
        this.STACK_INFO_SIDEWAYS = stackInfoSideways;
        this.comp = compIn;
        this.GUI = ResourceLocation.fromNamespaceAndPath((String)compIn.getMod(), (String)("textures/gui/" + compIn.getTail() + "_gui.png"));
    }

    public AbstractBaseMachineScreen(T menu, Inventory inv, Component name, DeferredComponent compIn, int fuelX, int fuelY, int fuelH, int helpX, int helpY, int titleX, boolean stackInfoSideways) {
        super(menu, inv, name);
        this.machineMenu = menu;
        this.titleLabelX = titleX;
        this.titleLabelY = -10;
        this.FUEL_XPOS = fuelX;
        this.FUEL_YPOS = fuelY;
        this.INFO_XPOS = helpX;
        this.INFO_YPOS = helpY;
        this.STACK_INFO_SIDEWAYS = stackInfoSideways;
        this.comp = compIn;
        this.GUI = ResourceLocation.fromNamespaceAndPath((String)compIn.getMod(), (String)("textures/gui/" + compIn.getTail() + "_gui.png"));
        this.FUEL_HEIGHT = fuelH;
    }

    public int getYSize() {
        return this.imageHeight;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.getXSize()) / 2;
        this.topPos = (this.height - this.getYSize()) / 2;
    }

    protected boolean hasClickedOutside(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.getXSize()) || pMouseY >= (double)(pGuiTop + this.getYSize());
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0xFFFFFF);
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.getXSize()) / 2;
        int relY = (this.height - this.getYSize()) / 2;
        int guiLeft = this.leftPos;
        int guiTop = this.topPos;
        graphics.blit(this.GUI, relX, relY, 0, 0, this.getXSize(), this.getYSize());
        int m = (int)(this.machineMenu.getFuelPercentage() * (float)this.FUEL_HEIGHT);
        graphics.blit(this.GUI, guiLeft + this.FUEL_XPOS, guiTop + this.FUEL_YPOS + this.FUEL_HEIGHT - m, this.FUEL_ICONX, this.FUEL_ICONY + this.FUEL_HEIGHT - m, 8, m);
        graphics.blit(this.GUI, guiLeft + this.INFO_XPOS, guiTop + this.INFO_YPOS, 184, 12, 12, 12);
        if (ModList.get().isLoaded("jei")) {
            if (this.STACK_INFO_SIDEWAYS) {
                this.blitAlt(graphics, this.INFO_XPOS - 15, this.INFO_YPOS, 196, 0, 12, 12, mouseX, mouseY);
            } else {
                this.blitAlt(graphics, this.INFO_XPOS, this.INFO_YPOS + 15, 196, 0, 12, 12, mouseX, mouseY);
            }
        }
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        AbstractMachineSlot machineSlot;
        MutableComponent comp;
        Slot slot;
        boolean notCarrying = ((AbstractBaseMachineMenu)this.menu).getCarried().isEmpty();
        ArrayList<Component> hoveringText = new ArrayList<Component>();
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem() && (slot = this.hoveredSlot) instanceof AbstractMachineSlot && (comp = (machineSlot = (AbstractMachineSlot)slot).getComp()) != null) {
            hoveringText.add((Component)comp.withStyle(ChatFormatting.GREEN));
        }
        if (notCarrying && AbstractBaseMachineScreen.isInRect(this.leftPos + this.FUEL_XPOS, this.topPos + this.FUEL_YPOS, 8, this.FUEL_HEIGHT, mouseX, mouseY)) {
            int fuel = this.machineMenu.getFuelStored() / 100;
            String strFuel = this.df.format(fuel) + "/" + this.df.format(this.machineMenu.getMaxFuel() / 100.0f);
            hoveringText.add((Component)CompUtils.getArgComp("fuel", strFuel));
        }
        if (notCarrying && AbstractBaseMachineScreen.isInRect(this.leftPos + this.INFO_XPOS - 1, this.topPos + this.INFO_YPOS - 1, 14, 14, mouseX, mouseY)) {
            this.getAdditionalInfoHover(hoveringText);
        }
        if (!hoveringText.isEmpty()) {
            graphics.renderComponentTooltip(this.font, hoveringText, mouseX, mouseY);
        } else {
            super.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    protected void getAdditionalInfoHover(List<Component> hoveringText) {
        hoveringText.add((Component)this.comp.get());
        hoveringText.add((Component)CompUtils.getComp("fuel_excess.info"));
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public void blitAlt(@NotNull GuiGraphics graphics, int offsetX, int offsetY, int iconX, int iconY, int width, int height, int mouseX, int mouseY) {
        if (AbstractBaseMachineScreen.isInRect(this.leftPos + offsetX, this.topPos + offsetY, width, height, mouseX, mouseY)) {
            graphics.blit(this.GUI, this.leftPos + offsetX, this.topPos + offsetY, iconX, iconY + height, width, height);
        } else {
            graphics.blit(this.GUI, this.leftPos + offsetX, this.topPos + offsetY, iconX, iconY, width, height);
        }
    }
}

