/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.base;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vapourdrive.vapourware.shared.base.IFuelUser;
import vapourdrive.vapourware.shared.utils.MachineUtils;

public abstract class AbstractBaseFuelUserTile
extends BlockEntity
implements IFuelUser {
    public final int maxFuel;
    public final int minWorkFuel;
    public int toAdd = 0;
    public int increment = 0;
    private ItemStack currentFuelStack = ItemStack.EMPTY;
    private int currentBurn = 0;
    public final int[] FUEL_SLOT = new int[]{0};
    public final int[] OUTPUT_SLOTS;

    public AbstractBaseFuelUserTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int maxFuel, int minWorkFuel, int[] OUTPUT_SLOTS) {
        super(pType, pPos, pBlockState);
        this.maxFuel = maxFuel;
        this.minWorkFuel = minWorkFuel;
        this.OUTPUT_SLOTS = OUTPUT_SLOTS;
    }

    @Override
    public void tickServer(BlockState state) {
        ItemStack fuel = this.getStackInSlot(MachineUtils.Area.FUEL, 0);
        MachineUtils.doFuelProcess(fuel, this);
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.increment = tag.getInt("increment");
        this.toAdd = tag.getInt("toAdd");
        this.addFuel(tag.getInt("fuel"), false);
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("increment", this.increment);
        tag.putInt("toAdd", this.toAdd);
        tag.putInt("fuel", this.getCurrentFuel());
    }

    @Override
    public boolean canWork(BlockState state) {
        boolean canWork = true;
        if (Objects.requireNonNull(this.getLevel()).hasNeighborSignal(this.worldPosition)) {
            canWork = false;
        } else if (this.getCurrentFuel() < this.getMinFuelToWork()) {
            canWork = false;
        }
        this.changeStateIfNecessary(state, canWork);
        return canWork;
    }

    public void changeStateIfNecessary(BlockState state, Boolean working) {
        assert (this.level != null);
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && !working.booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
        } else if (!((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && working.booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    public int getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public int getMinFuelToWork() {
        return this.minWorkFuel;
    }

    @Override
    public double getSpeedMultiplier() {
        return 1.0;
    }

    @Override
    public double getEfficiencyMultiplier() {
        return 1.0;
    }

    @Override
    public int getCurrentFuel() {
        return 0;
    }

    @Override
    public int getCurrentBurn() {
        return this.currentBurn;
    }

    @Override
    public void setCurrentBurn(int burn) {
        this.currentBurn = burn;
    }

    @Override
    public int getIncrementalFuelToAdd() {
        return this.increment;
    }

    @Override
    public void setIncrementalFuelToAdd(int increment) {
        this.increment = increment;
    }

    @Override
    public int getFuelToAdd() {
        return this.toAdd;
    }

    @Override
    public void setFuelToAdd(int toAdd) {
        this.toAdd = toAdd;
    }

    @Override
    public ItemStack getCurrentFuelStack() {
        return this.currentFuelStack;
    }

    @Override
    public void setCurrentFuelStack(ItemStack stack) {
        this.currentFuelStack = stack;
    }

    @Override
    public int[] getOutputSlots() {
        return this.OUTPUT_SLOTS;
    }
}

