/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vapourdrive.vapourware.config.ConfigSettings;
import vapourdrive.vapourware.setup.Registration;

@Mod(value="vapourware")
public class VapourWare {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "vapourware";
    public static final boolean debugMode = false;
    public static final ArrayList<ItemLike> seeds = new ArrayList();
    public static final DecimalFormat decimalFormat = new DecimalFormat("#,###");

    public VapourWare(ModContainer container) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigSettings.SERVER_CONFIG);
        Registration.init(container.getEventBus());
        Objects.requireNonNull(container.getEventBus()).addListener(Registration::buildContents);
    }

    public static void debugLog(String toLog) {
        if (VapourWare.isDebugMode()) {
            LOGGER.log(Level.DEBUG, toLog);
        }
    }

    public static boolean isDebugMode() {
        if (ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp")) {
            // empty if block
        }
        return false;
    }
}

