/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import fr.frinn.custommachinery.impl.util.Restriction;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Range<T extends Comparable<T>> {
    private final List<Restriction<T>> restrictions;

    public Range(List<Restriction<T>> restrictions) {
        this.restrictions = restrictions;
    }

    public List<Restriction<T>> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Iterator<Restriction<T>> i = this.restrictions.iterator();
        while (i.hasNext()) {
            Restriction<T> r = i.next();
            buf.append(r.toString());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public T match(List<T> things) {
        Comparable matched = null;
        for (Comparable thing : things) {
            if (!this.contains(thing) || matched != null && thing.compareTo(matched) <= 0) continue;
            matched = thing;
        }
        return (T)matched;
    }

    public boolean contains(T thing) {
        for (Restriction<T> restriction : this.restrictions) {
            if (!restriction.contains(thing)) continue;
            return true;
        }
        return false;
    }

    public String toFormattedString() {
        StringBuilder buf = new StringBuilder();
        Iterator<Restriction<T>> i = this.restrictions.iterator();
        while (i.hasNext()) {
            Restriction<T> r = i.next();
            buf.append(r.toFormattedString());
            if (!i.hasNext()) continue;
            buf.append(" or ");
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range range = (Range)obj;
        return Objects.equals(this.restrictions, range.restrictions);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return hash;
    }
}

