/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineBlockState;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final Random RAND = new Random();
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,###");

    public static boolean canPlayerManageMachines(Player player) {
        return player.hasPermissions(Objects.requireNonNull(player.getServer()).getOperatorUserPermissionLevel());
    }

    public static Vec3 vec3dFromBlockPos(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static AABB rotateBox(AABB box, Direction to) {
        return switch (to) {
            case Direction.EAST -> new AABB(box.minZ, box.minY, -box.minX, box.maxZ, box.maxY, -box.maxX);
            case Direction.NORTH -> new AABB(-box.minX, box.minY, -box.minZ, -box.maxX, box.maxY, -box.maxZ);
            case Direction.WEST -> new AABB(-box.minZ, box.minY, box.minX, -box.maxZ, box.maxY, box.maxX);
            default -> new AABB(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
        };
    }

    public static boolean isResourceNameValid(String resourceLocation) {
        try {
            ResourceLocation location = ResourceLocation.parse((String)resourceLocation);
            return true;
        }
        catch (ResourceLocationException e) {
            return false;
        }
    }

    public static float getMachineBreakSpeed(MachineAppearance appearance, BlockGetter level, BlockPos pos, Player player) {
        float hardness = appearance.getHardness();
        if (hardness <= 0.0f) {
            return 0.0f;
        }
        float digSpeed = player.getDigSpeed((BlockState)MachineBlockState.CACHE.getUnchecked((Object)appearance), pos);
        float canHarvest = EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)((BlockState)MachineBlockState.CACHE.getUnchecked((Object)appearance)), (BlockGetter)level, (BlockPos)pos) ? 30.0f : 100.0f;
        return digSpeed / hardness / canHarvest;
    }

    public static int toInt(long l) {
        try {
            return Math.toIntExact(l);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    public static String format(int number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static MutableComponent getBlockName(IIngredient<PartialBlockState> ingredient) {
        if (ingredient.getAll().size() == 1) {
            CustomMachine machine;
            ResourceLocation machineID;
            PartialBlockState partialBlockState = ingredient.getAll().get(0);
            if (partialBlockState.getBlockState().getBlock() instanceof CustomMachineBlock && partialBlockState.getNbt() != null && partialBlockState.getNbt().contains("machineID", 8) && (machineID = ResourceLocation.tryParse((String)partialBlockState.getNbt().getString("machineID"))) != null && (machine = CustomMachinery.MACHINES.get(machineID)) != null) {
                return (MutableComponent)machine.getName();
            }
            return partialBlockState.getName();
        }
        return Component.literal((String)ingredient.toString());
    }

    public static long clamp(long value, long min, long max) {
        return value < min ? min : Math.min(value, max);
    }

    public static Component itemIngredientName(SizedIngredient ingredient) {
        if (ingredient.getItems().length == 0) {
            return Items.AIR.getDescription();
        }
        return ingredient.getItems()[0].getHoverName();
    }

    public static Component fluidIngredientName(SizedFluidIngredient ingredient) {
        if (ingredient.getFluids().length == 0) {
            return Fluids.EMPTY.getFluidType().getDescription();
        }
        return ingredient.getFluids()[0].getHoverName();
    }

    public static String incrementLastNumber(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        Pattern p = Pattern.compile("(\\d+)(?!.*\\d)");
        Matcher m = p.matcher(input);
        if (m.find()) {
            String numberStr = m.group(1);
            int width = numberStr.length();
            int number = Integer.parseInt(numberStr);
            String newNumber = String.format("%0" + width + "d", ++number);
            return input.substring(0, m.start()) + newNumber + input.substring(m.end());
        }
        return input + "1";
    }
}

