/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.TagUtil;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableHelper {
    private static final List<ResourceLocation> tables = new ArrayList<ResourceLocation>();
    private static Map<ResourceLocation, List<LootData>> lootsMap = new HashMap<ResourceLocation, List<LootData>>();

    public static void addTable(ResourceLocation table) {
        if (!tables.contains(table)) {
            tables.add(table);
        }
    }

    public static void generate(MinecraftServer server) {
        lootsMap.clear();
        LootParams params = new LootParams.Builder(server.overworld()).create(Registration.CUSTOM_MACHINE_LOOT_PARAMETER_SET);
        LootContext context = new LootContext.Builder(params).create(Optional.empty());
        for (ResourceLocation table : tables) {
            List<LootData> loots = LootTableHelper.getLoots(table, server, context);
            lootsMap.put(table, loots);
        }
    }

    private static List<LootData> getLoots(ResourceLocation table, MinecraftServer server, LootContext context) {
        ArrayList<LootData> loots = new ArrayList<LootData>();
        LootTable lootTable = server.reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)table));
        BiFunction globalFunction = lootTable.compositeFunction;
        List<LootPool> pools = LootTableHelper.getPoolsFromLootTable(lootTable);
        if (pools == null) {
            return Collections.emptyList();
        }
        for (LootPool pool : pools) {
            List entries = pool.entries;
            float total = entries.stream().filter(entry -> entry instanceof LootPoolSingletonContainer).mapToInt(entry -> ((LootPoolSingletonContainer)entry).weight).sum();
            String rolls = LootTableHelper.getBaseRolls(pool.getRolls(), context);
            String bonusRolls = LootTableHelper.getBonusRolls(pool.getBonusRolls(), context);
            entries.stream().filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).forEach(entry -> {
                Consumer<ItemStack> consumer = stack -> loots.add(new LootData((ItemStack)stack, (float)entry.weight / total, rolls, bonusRolls));
                consumer = LootTableHelper.applyFunctions(consumer, entry.functions, globalFunction, context);
                entry.createItemStack(consumer, context);
            });
            entries.stream().filter(entry -> entry instanceof TagEntry).map(entry -> (TagEntry)entry).forEach(entry -> {
                Consumer<ItemStack> consumer = stack -> loots.add(new LootData((ItemStack)stack, (float)entry.weight / total / (float)(entry.expand ? TagUtil.getItems((TagKey<Item>)entry.tag).count() : 1L), rolls, bonusRolls));
                consumer = LootTableHelper.applyFunctions(consumer, entry.functions, globalFunction, context);
                entry.createItemStack(consumer, context);
            });
            entries.stream().filter(entry -> entry instanceof NestedLootTable).map(entry -> (NestedLootTable)entry).map(entry -> LootTableHelper.getLoots((ResourceLocation)entry.contents.map(ResourceKey::location, LootTable::getLootTableId), server, context)).forEach(loots::addAll);
        }
        return loots;
    }

    private static Consumer<ItemStack> applyFunctions(Consumer<ItemStack> consumer, List<LootItemFunction> functions, BiFunction<ItemStack, LootContext, ItemStack> globalFunction, LootContext context) {
        for (LootItemFunction function : functions) {
            consumer = LootItemFunction.decorate((BiFunction)function, consumer, (LootContext)context);
        }
        return LootItemFunction.decorate(globalFunction, consumer, (LootContext)context);
    }

    private static String getBaseRolls(NumberProvider rolls, LootContext context) {
        NumberProvider numberProvider = rolls;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantValue.class, UniformGenerator.class, BinomialDistributionGenerator.class}, (Object)numberProvider, n)) {
            case 0 -> {
                ConstantValue value = (ConstantValue)numberProvider;
                yield Math.round(value.value()) + " Rolls";
            }
            case 1 -> {
                UniformGenerator uniform = (UniformGenerator)numberProvider;
                yield "[" + uniform.min().getInt(context) + "," + uniform.max().getInt(context) + "] Rolls (uniform)";
            }
            case 2 -> {
                BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)numberProvider;
                yield "[0," + binomial.n().getInt(context) + "] Rolls (binomial)";
            }
            default -> "";
        };
    }

    private static String getBonusRolls(NumberProvider rolls, LootContext context) {
        NumberProvider numberProvider = rolls;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantValue.class, UniformGenerator.class, BinomialDistributionGenerator.class}, (Object)numberProvider, n)) {
            case 0 -> {
                ConstantValue value = (ConstantValue)numberProvider;
                if (value.value() != 0.0f) {
                    yield Math.round(value.value() * context.getLuck()) + " Rolls";
                }
                yield "";
            }
            case 1 -> {
                UniformGenerator uniform = (UniformGenerator)numberProvider;
                yield "[" + (float)uniform.min().getInt(context) * context.getLuck() + "," + (float)uniform.max().getInt(context) * context.getLuck() + "] Rolls (uniform)";
            }
            case 2 -> {
                BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)numberProvider;
                yield "[0," + (float)binomial.n().getInt(context) * context.getLuck() + "] Rolls (binomial)";
            }
            default -> "";
        };
    }

    public static Map<ResourceLocation, List<LootData>> getLoots() {
        return lootsMap;
    }

    public static void receiveLoots(Map<ResourceLocation, List<LootData>> newLoots) {
        lootsMap = newLoots;
    }

    public static List<LootData> getLootsForTable(ResourceLocation table) {
        return lootsMap.getOrDefault(table, Collections.emptyList());
    }

    public static List<LootPool> getPoolsFromLootTable(LootTable table) {
        for (Field field : LootTable.class.getDeclaredFields()) {
            if (!field.getName().equals("e") && !field.getName().equals("f_79109_") && !field.getName().equals("pools")) continue;
            field.setAccessible(true);
            try {
                return (List)field.get(table);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        throw new RuntimeException("NOPE");
    }

    public record LootData(ItemStack stack, double chance, String rolls, String bonusRolls) {
        public static StreamCodec<RegistryFriendlyByteBuf, LootData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, LootData::stack, (StreamCodec)ByteBufCodecs.DOUBLE, LootData::chance, (StreamCodec)ByteBufCodecs.STRING_UTF8, LootData::rolls, (StreamCodec)ByteBufCodecs.STRING_UTF8, LootData::bonusRolls, LootData::new);
    }
}

