/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CRemoveMachinePacket(ResourceLocation id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CRemoveMachinePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("remove_machine"));
    public static final StreamCodec<FriendlyByteBuf, CRemoveMachinePacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CRemoveMachinePacket::id, CRemoveMachinePacket::new);

    public CustomPacketPayload.Type<CRemoveMachinePacket> type() {
        return TYPE;
    }

    public static void handle(CRemoveMachinePacket packet, IPayloadContext context) {
        CustomMachine machine;
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer() != null && Utils.canPlayerManageMachines((Player)player) && (machine = CustomMachinery.MACHINES.get(packet.id)) != null) {
            context.enqueueWork(() -> {
                CustomMachinery.LOGGER.info("Player: {} removed machine: {}", (Object)player.getName().getString(), (Object)packet.id);
                if (FileUtils.deleteMachineJson(player.getServer(), machine.getLocation())) {
                    CustomMachinery.MACHINES.remove(packet.id);
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SUpdateMachinesPacket(CustomMachinery.MACHINES), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }
}

