/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CAddMachinePacket(String id, Component name, boolean kubejs) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CAddMachinePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("add_machine"));
    public static final StreamCodec<ByteBuf, CAddMachinePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CAddMachinePacket::id, (StreamCodec)ByteBufCodecs.fromCodec(TextComponentUtils.CODEC.codec()), CAddMachinePacket::name, (StreamCodec)ByteBufCodecs.BOOL, CAddMachinePacket::kubejs, CAddMachinePacket::new);

    public CustomPacketPayload.Type<CAddMachinePacket> type() {
        return TYPE;
    }

    public static void handle(CAddMachinePacket packet, IPayloadContext context) {
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer() != null && Utils.canPlayerManageMachines((Player)player)) {
            context.enqueueWork(() -> {
                ResourceLocation loc = packet.id.contains(":") ? ResourceLocation.parse((String)packet.id) : CustomMachinery.rl(packet.id);
                CustomMachinery.LOGGER.info("Player: {} added new Machine: {}", (Object)player.getName().getString(), (Object)loc);
                CustomMachine newMachine = new CustomMachineBuilder().setLocation(MachineLocation.fromLoader(packet.kubejs ? MachineLocation.Loader.KUBEJS : MachineLocation.Loader.DEFAULT, loc, "")).setName(packet.name).build();
                FileUtils.writeNewMachineJson(player.getServer(), newMachine, packet.kubejs);
            });
        }
    }
}

