/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine.builder;

import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.crafting.IProcessorTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearanceManager;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.MachineAppearanceBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CustomMachineBuilder {
    private Component name;
    private final MachineAppearanceBuilder defaultAppearance;
    private final Map<MachineStatus, MachineAppearanceBuilder> appearance;
    private final List<Component> tooltips;
    private final List<IGuiElement> guiElements;
    private final List<IGuiElement> jeiElements;
    private final List<ResourceLocation> catalysts;
    private final List<IMachineComponentTemplate<?>> components;
    private MachineLocation location;
    private IProcessorTemplate<?> processor;

    public CustomMachineBuilder() {
        this.name = Component.literal((String)"New Machine");
        this.defaultAppearance = new MachineAppearanceBuilder(null);
        this.appearance = Arrays.stream(MachineStatus.values()).collect(Collectors.toMap(Function.identity(), MachineAppearanceBuilder::new));
        this.tooltips = new ArrayList<Component>();
        this.guiElements = new ArrayList<IGuiElement>();
        this.jeiElements = new ArrayList<IGuiElement>();
        this.catalysts = new ArrayList<ResourceLocation>();
        this.components = new ArrayList();
        this.location = MachineLocation.fromDefault(CustomMachinery.rl("new_machine"), "");
        this.processor = MachineProcessor.Template.DEFAULT;
    }

    public CustomMachineBuilder(CustomMachine machine) {
        this.name = machine.getName();
        this.defaultAppearance = new MachineAppearanceBuilder(machine.getAppearanceManager().getDefaultProperties(), null);
        this.appearance = Arrays.stream(MachineStatus.values()).collect(Collectors.toMap(Function.identity(), status -> new MachineAppearanceBuilder(machine.getAppearanceManager().getStatusProperties((MachineStatus)((Object)status)), (MachineStatus)((Object)status))));
        this.tooltips = new ArrayList<Component>(machine.getTooltips());
        this.guiElements = new ArrayList<IGuiElement>(machine.getGuiElements());
        this.jeiElements = new ArrayList<IGuiElement>(machine.getJeiElements());
        this.catalysts = new ArrayList<ResourceLocation>(machine.getCatalysts());
        this.components = new ArrayList<IMachineComponentTemplate<? extends IMachineComponent>>(machine.getComponentTemplates());
        this.location = machine.getLocation();
        this.processor = machine.getProcessorTemplate();
    }

    public Component getName() {
        return this.name;
    }

    public CustomMachineBuilder setName(Component name) {
        this.name = name;
        return this;
    }

    public CustomMachineBuilder withAppearance(MachineStatus status, MachineAppearanceBuilder builder) {
        this.appearance.put(status, builder);
        return this;
    }

    public MachineAppearanceBuilder getAppearance(@Nullable MachineStatus status) {
        if (status == null) {
            return this.defaultAppearance;
        }
        return this.appearance.get((Object)status);
    }

    public CustomMachineBuilder withGuiElement(IGuiElement element) {
        this.guiElements.add(element);
        return this;
    }

    public List<IGuiElement> getGuiElements() {
        return this.guiElements;
    }

    public List<IMachineComponentTemplate<?>> getComponents() {
        return this.components;
    }

    public MachineLocation getLocation() {
        return this.location;
    }

    public CustomMachineBuilder setLocation(MachineLocation location) {
        this.location = location;
        return this;
    }

    public IProcessorTemplate<?> getProcessor() {
        return this.processor;
    }

    public void setProcessor(IProcessorTemplate<?> template) {
        this.processor = template;
    }

    public CustomMachineBuilder setId(ResourceLocation id) {
        MachineLocation.Loader loader = this.location.getLoader();
        String packName = this.location.getPackName();
        this.location = MachineLocation.fromLoader(loader, id, packName);
        return this;
    }

    public List<Component> getTooltips() {
        return this.tooltips;
    }

    public void setTooltips(List<Component> tooltips) {
        this.tooltips.clear();
        this.tooltips.addAll(tooltips);
    }

    public CustomMachine build() {
        MutableComponent name = this.name == null ? Component.literal((String)"New Machine") : this.name;
        MachineAppearanceManager appearance = new MachineAppearanceManager(this.defaultAppearance.build().getProperties(), this.appearance.get((Object)MachineStatus.IDLE).build(), this.appearance.get((Object)MachineStatus.RUNNING).build(), this.appearance.get((Object)MachineStatus.ERRORED).build(), this.appearance.get((Object)MachineStatus.PAUSED).build());
        ImmutableList tooltips = this.tooltips == null ? ImmutableList.of() : ImmutableList.copyOf(this.tooltips);
        ImmutableList guiElements = this.guiElements == null ? ImmutableList.of() : this.guiElements.stream().sorted(Comparator.comparing(element -> element.getType().getId().toString() + ":" + element.getId())).toList();
        ImmutableList jeiElements = this.jeiElements == null ? ImmutableList.of() : this.jeiElements.stream().sorted(Comparator.comparing(element -> element.getType().getId().toString() + ":" + element.getId())).toList();
        ImmutableList catalysts = this.catalysts == null ? ImmutableList.of() : ImmutableList.copyOf(this.catalysts);
        ImmutableList componentTemplates = this.components == null ? ImmutableList.of() : this.components.stream().sorted(Comparator.comparing(component -> component.getType().getId().toString() + ":" + component.getId())).toList();
        return new CustomMachine((Component)name, appearance, (List<Component>)tooltips, (List<IGuiElement>)guiElements, (List<IGuiElement>)jeiElements, (List<ResourceLocation>)catalysts, (List<IMachineComponentTemplate<? extends IMachineComponent>>)componentTemplates, this.processor).setLocation(this.location);
    }
}

