/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.data.KubeFileResourcePack;
import dev.latvian.mods.kubejs.script.data.VirtualDataPack;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.common.integration.kubejs.CustomMachineUpgradeJSBuilder;
import fr.frinn.custommachinery.common.integration.kubejs.CustomMachineryKubeJSPlugin;
import fr.frinn.custommachinery.common.integration.kubejs.function.FunctionKubeEvent;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;

public class KubeJSIntegration {
    public static MachineLocation getMachineLocation(Resource resource, String packName, ResourceLocation id) {
        try (PackResources pack = resource.source();){
            if (pack instanceof KubeFileResourcePack) {
                MachineLocation machineLocation = MachineLocation.fromKubeJS(id, packName);
                return machineLocation;
            }
            if (pack instanceof VirtualDataPack) {
                MachineLocation machineLocation = MachineLocation.fromKubeJSScript(id, packName);
                return machineLocation;
            }
            MachineLocation machineLocation = MachineLocation.fromDefault(id, packName);
            return machineLocation;
        }
    }

    public static List<MachineUpgrade> collectMachineUpgrades() {
        ScriptType.SERVER.console.info((Object)"Collecting Custom Machine upgrades from JS scripts.");
        CustomMachineUpgradeJSBuilder.UpgradeKubeEvent event = new CustomMachineUpgradeJSBuilder.UpgradeKubeEvent();
        CustomMachineryKubeJSPlugin.UPGRADES.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)event);
        ArrayList<MachineUpgrade> upgrades = new ArrayList();
        try {
            upgrades = event.getBuilders().stream().map(CustomMachineUpgradeJSBuilder::build).toList();
        }
        catch (Exception e) {
            ScriptType.SERVER.console.warn("Couldn't build machine upgrade", (Throwable)e);
        }
        ScriptType.SERVER.console.infof("Successfully added %s Custom Machine upgrades", new Object[]{event.getBuilders().size()});
        return upgrades;
    }

    public static CraftingResult sendFunctionRequirementEvent(String id, ICraftingContext context) {
        if (!CustomMachineryKubeJSPlugin.FUNCTIONS.hasListeners((Object)id)) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.function.no_listener", (Object[])new Object[]{id}));
        }
        EventResult result = CustomMachineryKubeJSPlugin.FUNCTIONS.post((KubeEvent)new FunctionKubeEvent(context), (Object)id);
        if (result.interruptTrue() || result.interruptDefault() || result.pass()) {
            return CraftingResult.success();
        }
        Object object = result.value();
        if (object instanceof Component) {
            Component error = (Component)object;
            return CraftingResult.error(error);
        }
        object = result.value();
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return CraftingResult.error((Component)Component.literal((String)charSequence.toString()));
        }
        return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.function.interrupt"));
    }

    public static void logError(Throwable error) {
        ScriptType.SERVER.console.error("Error while processing function requirement: ", error);
    }
}

