/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.mojang.serialization.DynamicOps;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.crafting.ComponentNotFoundException;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.IMachineAppearance;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.client.model.CustomMachineBakedModel;
import fr.frinn.custommachinery.common.component.DummyComponentManager;
import fr.frinn.custommachinery.common.component.MachineComponentManager;
import fr.frinn.custommachinery.common.crafting.DummyProcessor;
import fr.frinn.custommachinery.common.crafting.UpgradeManager;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.network.SRefreshCustomMachineTilePacket;
import fr.frinn.custommachinery.common.network.SUpdateMachineAppearancePacket;
import fr.frinn.custommachinery.common.network.SUpdateMachineGuiElementsPacket;
import fr.frinn.custommachinery.common.network.SUpdateMachineStatusPacket;
import fr.frinn.custommachinery.common.network.syncable.StringSyncable;
import fr.frinn.custommachinery.common.util.MachineList;
import fr.frinn.custommachinery.common.util.sound.SoundManager;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomMachineTile
extends MachineTile
implements ISyncableStuff {
    public static final ResourceLocation DUMMY = ResourceLocation.fromNamespaceAndPath((String)"custommachinery", (String)"dummy");
    private ResourceLocation id = DUMMY;
    private boolean paused = false;
    private IProcessor processor = new DummyProcessor(this);
    private MachineComponentManager componentManager = new DummyComponentManager(this);
    private final UpgradeManager upgradeManager = new UpgradeManager(this);
    private SoundManager soundManager;
    private MachineStatus status = MachineStatus.IDLE;
    private Component errorMessage = Component.empty();
    @Nullable
    private MachineAppearance customAppearance = null;
    @Nullable
    private List<IGuiElement> customGuiElements = null;
    @Nullable
    private Component ownerName;
    @Nullable
    private UUID ownerID;
    private final List<WeakReference<ServerPlayer>> players = new ArrayList<WeakReference<ServerPlayer>>();
    private boolean unloaded = false;

    public CustomMachineTile(BlockPos pos, BlockState state) {
        super(Registration.CUSTOM_MACHINE_TILE.get(), pos, state);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
        this.processor = this.getMachine().getProcessorTemplate().build(this);
        this.componentManager = new MachineComponentManager(this.getMachine().getComponentTemplates(), this);
        this.componentManager.getComponents().values().forEach(IMachineComponent::init);
    }

    @Override
    public CustomMachine getMachine() {
        CustomMachine machine = CustomMachinery.MACHINES.get(this.getId());
        if (machine != null) {
            return machine;
        }
        return CustomMachine.DUMMY;
    }

    @Override
    public MachineStatus getStatus() {
        if (this.isPaused()) {
            return MachineStatus.PAUSED;
        }
        return this.status;
    }

    @Override
    public Component getMessage() {
        return this.errorMessage;
    }

    @Override
    public void setStatus(MachineStatus status, Component message) {
        if (this.status != status) {
            this.componentManager.getComponents().values().forEach(component -> component.onStatusChanged(this.status, status, message));
            this.status = status;
            this.errorMessage = message;
            this.setChanged();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos pos = this.getBlockPos();
                serverLevel.updateNeighborsAt(pos, this.getBlockState().getBlock());
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SUpdateMachineStatusPacket(pos, this.status), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public void refreshMachine(@Nullable ResourceLocation id) {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        CompoundTag craftingManagerNBT = this.processor.serialize();
        CompoundTag componentManagerNBT = this.componentManager.serializeNBT((HolderLookup.Provider)this.getLevel().registryAccess());
        this.invalidateCapabilities();
        if (id == null) {
            id = this.getId();
        }
        this.id = id;
        this.processor = this.getMachine().getProcessorTemplate().build(this);
        this.componentManager = new MachineComponentManager(this.getMachine().getComponentTemplates(), this);
        this.processor.deserialize(craftingManagerNBT);
        this.componentManager.deserializeNBT(componentManagerNBT, (HolderLookup.Provider)this.getLevel().registryAccess());
        this.componentManager.getComponents().values().forEach(IMachineComponent::init);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level2, (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new SRefreshCustomMachineTilePacket(this.worldPosition, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void resetProcess() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.processor.reset();
    }

    @Override
    public MachineComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    @Override
    public IProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public MachineAppearance getAppearance() {
        if (this.customAppearance != null) {
            return this.customAppearance;
        }
        return this.getMachine().getAppearance(this.getStatus());
    }

    @Override
    public void setCustomAppearance(@Nullable IMachineAppearance customAppearance) {
        if (this.customAppearance == customAppearance) {
            return;
        }
        this.customAppearance = (MachineAppearance)customAppearance;
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getBlockPos();
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SUpdateMachineAppearancePacket(pos, this.customAppearance), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public List<IGuiElement> getGuiElements() {
        if (this.customGuiElements != null && !this.customGuiElements.isEmpty()) {
            return this.customGuiElements;
        }
        return this.getMachine().getGuiElements();
    }

    @Override
    public void setCustomGuiElements(@Nullable List<IGuiElement> customGuiElements) {
        if (this.customGuiElements == customGuiElements || this.customGuiElements != null && customGuiElements != null && !customGuiElements.isEmpty() && new HashSet<IGuiElement>(this.customGuiElements).containsAll(customGuiElements)) {
            return;
        }
        this.customGuiElements = customGuiElements;
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getBlockPos();
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SUpdateMachineGuiElementsPacket(pos, this.customGuiElements), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Iterator<WeakReference<ServerPlayer>> iterator = this.players.iterator();
            while (iterator.hasNext()) {
                CustomMachineContainer container;
                AbstractContainerMenu abstractContainerMenu;
                ServerPlayer player = (ServerPlayer)iterator.next().get();
                if (player == null || !((abstractContainerMenu = player.containerMenu) instanceof CustomMachineContainer) || (container = (CustomMachineContainer)abstractContainerMenu).getTile() != this) {
                    iterator.remove();
                    continue;
                }
                container.init();
            }
        }
    }

    @Override
    public void setOwner(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        this.ownerName = entity.getName();
        this.ownerID = entity.getUUID();
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return this.ownerID;
    }

    @Override
    @Nullable
    public Component getOwnerName() {
        return this.ownerName;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CustomMachineTile tile) {
        if (tile.componentManager == null || tile.processor == null) {
            return;
        }
        level.getProfiler().push("Component tick");
        tile.componentManager.serverTick();
        level.getProfiler().pop();
        if (tile.isPaused()) {
            return;
        }
        level.getProfiler().push("Crafting Manager tick");
        try {
            tile.processor.tick();
        }
        catch (ComponentNotFoundException e) {
            CustomMachinery.LOGGER.error(e.getMessage());
            tile.setPaused(true);
        }
        level.getProfiler().pop();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CustomMachineTile tile) {
        if (tile.componentManager == null || tile.processor == null) {
            return;
        }
        tile.componentManager.clientTick();
        if (tile.soundManager == null) {
            tile.soundManager = new SoundManager(pos);
        }
        if (!tile.soundManager.isCurrentlyPlaying(tile.getAppearance().getAmbientSound())) {
            if (tile.getAppearance().getAmbientSound() == Registration.AMBIENT_SOUND_PROPERTY.get().getDefaultValue()) {
                tile.soundManager.setSound(null);
            } else {
                tile.soundManager.setSound(tile.getAppearance().getAmbientSound());
            }
        }
        if (!tile.soundManager.isPlaying()) {
            tile.soundManager.play();
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        MachineList.addMachine(this);
        this.componentManager.getComponents().values().forEach(IMachineComponent::init);
    }

    public void setRemoved() {
        if (this.level != null && this.level.isClientSide() && this.soundManager != null) {
            this.soundManager.stop();
        }
        if (this.level != null && !this.level.isClientSide()) {
            this.componentManager.getComponents().values().forEach(IMachineComponent::onRemoved);
        }
        super.setRemoved();
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putString("machineID", this.id.toString());
        nbt.put("craftingManager", (Tag)this.processor.serialize());
        nbt.put("componentManager", (Tag)this.componentManager.serializeNBT(registries));
        nbt.putString("status", this.status.toString());
        nbt.putString("message", TextComponentUtils.toJsonString(this.errorMessage));
        if (this.ownerID != null) {
            nbt.putString("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            nbt.putString("ownerName", TextComponentUtils.toJsonString(this.ownerName));
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("machineID", 8) && this.getMachine() == CustomMachine.DUMMY) {
            this.setId(ResourceLocation.parse((String)nbt.getString("machineID")));
        }
        if (nbt.contains("craftingManager", 10)) {
            this.processor.deserialize(nbt.getCompound("craftingManager"));
        }
        if (nbt.contains("componentManager", 10)) {
            this.componentManager.deserializeNBT(nbt.getCompound("componentManager"), registries);
        }
        if (nbt.contains("status", 8)) {
            this.setStatus(MachineStatus.value(nbt.getString("status")));
        }
        if (nbt.contains("message", 8)) {
            this.errorMessage = TextComponentUtils.fromJsonString(nbt.getString("message"));
        }
        if (nbt.contains("ownerID", 8)) {
            this.ownerID = UUID.fromString(nbt.getString("ownerID"));
        }
        if (nbt.contains("ownerName", 8)) {
            this.ownerName = TextComponentUtils.fromJsonString(nbt.getString("ownerName"));
        }
        if (nbt.contains("appearance", 10)) {
            this.customAppearance = MachineAppearance.CODEC.read((DynamicOps)NbtOps.INSTANCE, nbt.get("appearance")).result().map(MachineAppearance::new).orElse(null);
        }
        if (nbt.contains("gui", 9)) {
            this.customGuiElements = IGuiElement.CODEC.listOf().read(NbtOps.INSTANCE, nbt.getList("gui", 10)).result().orElse(Collections.emptyList());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        nbt.putString("machineID", this.getId().toString());
        nbt.putString("status", this.status.toString());
        nbt.putString("message", TextComponentUtils.toJsonString(this.errorMessage));
        if (this.ownerID != null) {
            nbt.putString("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            nbt.putString("ownerName", TextComponentUtils.toJsonString(this.ownerName));
        }
        if (this.customAppearance != null) {
            MachineAppearance.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.customAppearance.getProperties()).result().ifPresent(appearance -> nbt.put("appearance", appearance));
        }
        if (this.customGuiElements != null && !this.customGuiElements.isEmpty()) {
            IGuiElement.CODEC.listOf().encodeStart(NbtOps.INSTANCE, this.customGuiElements).result().ifPresent(elements -> nbt.put("gui", elements));
        }
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public void refreshClientData() {
        this.requestModelDataUpdate();
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(CustomMachineBakedModel.APPEARANCE, (Object)this.getAppearance().copy()).with(CustomMachineBakedModel.STATUS, (Object)this.getStatus()).build();
    }

    @Override
    public boolean isUnloaded() {
        return this.unloaded;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        if (this.getLevel() == null) {
            return;
        }
        IProcessor iProcessor = this.processor;
        if (iProcessor instanceof ISyncableStuff) {
            ISyncableStuff syncableProcessor = (ISyncableStuff)((Object)iProcessor);
            syncableProcessor.getStuffToSync(container);
        }
        RegistryAccess registries = this.getLevel().registryAccess();
        this.componentManager.getStuffToSync(container);
        container.accept(StringSyncable.create(() -> this.status.toString(), status -> {
            this.status = MachineStatus.value(status);
        }));
        container.accept(StringSyncable.create(() -> Component.Serializer.toJson((Component)this.errorMessage, (HolderLookup.Provider)registries), errorMessage -> {
            this.errorMessage = Component.Serializer.fromJson((String)errorMessage, (HolderLookup.Provider)registries);
        }));
    }

    public void startInteracting(ServerPlayer player) {
        if (this.players.stream().noneMatch(ref -> ref.get() == player)) {
            this.players.add(new WeakReference<ServerPlayer>(player));
        }
    }

    public void stopInteracting(ServerPlayer player) {
        Iterator<WeakReference<ServerPlayer>> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            ServerPlayer ref = (ServerPlayer)iterator.next().get();
            if (ref != null && ref != player && ref.containerMenu instanceof CustomMachineContainer) continue;
            iterator.remove();
        }
    }
}

