/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.api.utils.Filter;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.FluidStackSyncable;
import fr.frinn.custommachinery.common.network.syncable.IOSideConfigSyncable;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent,
IFluidHandler {
    private final String id;
    private final int capacity;
    private final int maxInput;
    private final int minInput;
    private final int maxOutput;
    private final int minOutput;
    private final Filter<Fluid> filter;
    private final IOSideConfig config;
    private final boolean unique;
    private FluidStack fluidStack = FluidStack.EMPTY;
    private boolean bypassLimit = false;

    public FluidMachineComponent(IMachineComponentManager manager, ComponentIOMode mode, String id, int capacity, int maxInput, int minInput, int maxOutput, int minOutput, Filter<Fluid> filter, IOSideConfig.Template configTemplate, boolean unique) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.minInput = minInput;
        this.maxOutput = maxOutput;
        this.minOutput = minOutput;
        this.filter = filter;
        this.config = configTemplate.build(this);
        this.unique = unique;
    }

    public MachineComponentType<FluidMachineComponent> getType() {
        return Registration.FLUID_MACHINE_COMPONENT.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack.copy();
        this.getManager().markDirty();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxInput() {
        return this.maxInput;
    }

    public int getMinInput() {
        return this.minInput;
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public int getMinOutput() {
        return this.minOutput;
    }

    public IOSideConfig getConfig() {
        return this.config;
    }

    @Override
    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (!this.fluidStack.isEmpty()) {
            nbt.put("stack", this.fluidStack.save(registries));
        }
        nbt.put("config", (Tag)this.config.serialize());
    }

    @Override
    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("stack", 10)) {
            this.fluidStack = FluidStack.parse((HolderLookup.Provider)registries, (Tag)nbt.getCompound("stack")).orElse(FluidStack.EMPTY);
        }
        if (nbt.contains("config")) {
            this.config.deserialize(nbt.getCompound("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(FluidStackSyncable.create(() -> this.fluidStack, fluidStack -> {
            this.fluidStack = fluidStack;
        }));
        container.accept(IOSideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.fluidStack.getAmount() / (double)this.capacity));
    }

    public int fillBypassLimit(FluidStack resource, IFluidHandler.FluidAction action) {
        this.bypassLimit = true;
        int filled = this.fill(resource, action);
        this.bypassLimit = false;
        return filled;
    }

    public FluidStack drainBypassLimit(int amount, IFluidHandler.FluidAction action) {
        this.bypassLimit = true;
        FluidStack drained = this.drain(amount, action);
        this.bypassLimit = false;
        return drained;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        this.validateTankIndex(tank);
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        this.validateTankIndex(tank);
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        this.validateTankIndex(tank);
        if (this.unique && this.fluidStack.isEmpty() && this.getManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).stream().flatMap(handler -> handler.getComponents().stream()).anyMatch(component -> component != this && FluidStack.isSameFluidSameComponents((FluidStack)component.getFluid(), (FluidStack)stack))) {
            return false;
        }
        if (!this.filter.test(stack.getFluid())) {
            return false;
        }
        return this.fluidStack.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)this.fluidStack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        int maxFill = resource.getAmount();
        if (!this.bypassLimit) {
            int n = maxFill = maxFill < this.getMinInput() ? 0 : Math.min(maxFill, this.getMaxInput());
        }
        if (this.fluidStack.isEmpty()) {
            maxFill = Math.min(maxFill, this.getCapacity());
            if (action.execute()) {
                this.setFluidStack(resource.copyWithAmount(maxFill));
            }
        } else {
            maxFill = Math.min(maxFill, this.getCapacity() - this.getFluid().getAmount());
            if (action.execute()) {
                this.fluidStack.grow(maxFill);
                this.getManager().markDirty();
            }
        }
        return maxFill;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (!this.bypassLimit) {
            maxDrain = maxDrain < this.getMinOutput() ? 0 : Math.min(maxDrain, this.getMaxOutput());
        }
        maxDrain = Math.min(maxDrain, this.fluidStack.getAmount());
        FluidStack removed = this.fluidStack.copyWithAmount(maxDrain);
        if (action.execute()) {
            this.fluidStack.shrink(maxDrain);
            this.getManager().markDirty();
        }
        return removed;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || this.fluidStack.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.fluidStack)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    protected void validateTankIndex(int tank) {
        if (tank != 0) {
            throw new RuntimeException("Tank " + tank + " not in valid range - [0," + this.getTanks() + ")");
        }
    }

    public int getRecipeRemainingSpace() {
        if (!this.fluidStack.isEmpty()) {
            return this.capacity - this.fluidStack.getAmount();
        }
        return this.capacity;
    }

    public void recipeInsert(Fluid fluid, long amount, CompoundTag nbt) {
        if (amount <= 0L) {
            return;
        }
        if (this.fluidStack.isEmpty()) {
            this.fluidStack = new FluidStack(fluid, (int)amount);
        } else {
            amount = Utils.clamp(amount, 0L, this.getRecipeRemainingSpace());
            this.fluidStack.grow((int)amount);
        }
        this.getManager().markDirty();
    }

    public void recipeExtract(long amount) {
        if (amount <= 0L) {
            return;
        }
        amount = Utils.clamp(amount, 0L, this.fluidStack.getAmount());
        this.fluidStack.shrink((int)amount);
        this.getManager().markDirty();
    }

    public record Template(String id, int capacity, int maxInput, int minInput, int maxOutput, int minOutput, Filter<Fluid> filter, ComponentIOMode mode, IOSideConfig.Template config, boolean unique) implements IMachineComponentTemplate<FluidMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(fluidMachineComponentTemplate -> fluidMachineComponentTemplate.group(NamedCodec.STRING.fieldOf("id").forGetter(template -> template.id), NamedCodec.intRange(1, Integer.MAX_VALUE).fieldOf("capacity").forGetter(template -> template.capacity), NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("maxInput").forGetter(template -> template.maxInput == template.capacity ? Optional.empty() : Optional.of(template.maxInput)), NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("minInput", 0).forGetter(template -> template.minInput), NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("maxOutput").forGetter(template -> template.maxOutput == template.capacity ? Optional.empty() : Optional.of(template.maxOutput)), NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("minOutput", 0).forGetter(template -> template.minOutput), Filter.codec(DefaultCodecs.registryValueOrTag(BuiltInRegistries.FLUID)).orElse(Filter.empty()).forGetter(template -> template.filter), ComponentIOMode.CODEC.optionalFieldOf("mode", ComponentIOMode.BOTH).forGetter(template -> template.mode), IOSideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> template.config == template.mode.getBaseConfig() ? Optional.empty() : Optional.of(template.config)), NamedCodec.BOOL.optionalFieldOf("unique", false).forGetter(template -> template.unique)).apply((Applicative)fluidMachineComponentTemplate, (id, capacity, maxInput, minInput, maxOutput, minOutput, filter, mode, config, unique) -> new Template((String)id, (int)capacity, maxInput.orElse(capacity), (int)minInput, maxOutput.orElse(capacity), (int)minOutput, (Filter<Fluid>)filter, (ComponentIOMode)((Object)((Object)mode)), config.orElse(mode.getBaseConfig()), (boolean)unique)), "Fluid machine component");

        @Override
        public MachineComponentType<FluidMachineComponent> getType() {
            return Registration.FLUID_MACHINE_COMPONENT.get();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            if (this.mode != ComponentIOMode.BOTH && isInput != this.mode.isInput()) {
                return false;
            }
            if (ingredient instanceof FluidStack) {
                FluidStack stack = (FluidStack)ingredient;
                return this.filter.test(stack.getFluid());
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    if (object instanceof FluidStack) {
                        FluidStack stack = (FluidStack)object;
                        return this.filter.test(stack.getFluid());
                    }
                    return false;
                });
            }
            return false;
        }

        @Override
        public FluidMachineComponent build(IMachineComponentManager manager) {
            return new FluidMachineComponent(manager, this.mode, this.id, this.capacity, this.maxInput, this.minInput, this.maxOutput, this.minOutput, this.filter, this.config, this.unique);
        }
    }
}

