/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class DropMachineComponent
extends AbstractMachineComponent {
    public DropMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<DropMachineComponent> getType() {
        return Registration.DROP_MACHINE_COMPONENT.get();
    }

    public int getItemAmount(Ingredient ingredient, int radius, boolean whitelist) {
        List<Item> filter = Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).toList();
        BlockPos from = this.getManager().getTile().getBlockPos().offset(radius, radius, radius);
        BlockPos to = this.getManager().getTile().getBlockPos().offset(-radius, -radius, -radius);
        AABB box = new AABB((double)from.getX(), (double)from.getY(), (double)from.getZ(), (double)to.getX(), (double)to.getY(), (double)to.getZ());
        return this.getManager().getLevel().getEntitiesOfClass(ItemEntity.class, box, entity -> filter.contains(entity.getItem().getItem()) == whitelist && entity.blockPosition().closerThan((Vec3i)this.getManager().getTile().getBlockPos(), (double)radius)).stream().mapToInt(entity -> entity.getItem().getCount()).sum();
    }

    public void consumeItem(Ingredient ingredient, int amount, int radius, boolean whitelist) {
        List<Item> filter = Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).toList();
        AtomicInteger toRemove = new AtomicInteger(amount);
        BlockPos from = this.getManager().getTile().getBlockPos().offset(radius, radius, radius);
        BlockPos to = this.getManager().getTile().getBlockPos().offset(-radius, -radius, -radius);
        AABB box = new AABB((double)from.getX(), (double)from.getY(), (double)from.getZ(), (double)to.getX(), (double)to.getY(), (double)to.getZ());
        this.getManager().getLevel().getEntitiesOfClass(ItemEntity.class, box, entity -> filter.contains(entity.getItem().getItem()) == whitelist && entity.blockPosition().closerThan((Vec3i)this.getManager().getTile().getBlockPos(), (double)radius)).forEach(entity -> {
            int maxRemove = Math.min(toRemove.get(), entity.getItem().getCount());
            if (maxRemove == entity.getItem().getCount()) {
                entity.remove(Entity.RemovalReason.DISCARDED);
            } else {
                entity.getItem().shrink(maxRemove);
            }
            toRemove.addAndGet(-maxRemove);
        });
    }

    public boolean produceItem(ItemStack stack) {
        Level world = this.getManager().getLevel();
        BlockPos pos = this.getManager().getTile().getBlockPos().above();
        ItemEntity entity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
        return world.addFreshEntity((Entity)entity);
    }
}

