/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class GroupWidget
extends AbstractWidget
implements ContainerEventHandler {
    public final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    public final Minecraft mc = Minecraft.getInstance();
    public final Font font;
    @Nullable
    private GuiEventListener focused;
    private boolean dragging;

    public GroupWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        this.font = this.mc.font;
    }

    public <T extends AbstractWidget> T addWidget(T widget) {
        this.children.add(widget);
        return widget;
    }

    public List<AbstractWidget> children() {
        return this.children;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.children.forEach(children -> children.render(graphics, mouseX, mouseY, partialTick));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.children.forEach(children -> children.updateNarration(narrationElementOutput));
    }

    public void setX(int x) {
        int delta = x - this.getX();
        super.setX(x);
        this.children.forEach(children -> children.setX(children.getX() + delta));
    }

    public void setY(int y) {
        int delta = y - this.getY();
        super.setY(y);
        this.children.forEach(children -> children.setY(children.getY() + delta));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (AbstractWidget children : this.children) {
            if (!children.mouseClicked(mouseX, mouseY, button)) continue;
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            this.focused = children;
            children.setFocused(true);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (AbstractWidget children : this.children) {
            if (!children.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (AbstractWidget children : this.children) {
            if (!children.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.focused != null) {
            return this.focused.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.children.forEach(children -> children.mouseMoved(mouseX, mouseY));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (AbstractWidget children : this.children) {
            if (!children.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (AbstractWidget children : this.children) {
            if (!children.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (AbstractWidget children : this.children) {
            if (!children.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focused = focused;
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.setFocused(null);
        }
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (event instanceof FocusNavigationEvent.ArrowNavigation) {
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
            GuiEventListener focused = this.getFocused();
            return switch (arrowNavigation.direction()) {
                default -> throw new MatchException(null, null);
                case ScreenDirection.LEFT, ScreenDirection.UP -> {
                    if (focused == null) {
                        yield ComponentPath.path((ContainerEventHandler)this, (ComponentPath)this.children.getLast().nextFocusPath(event));
                    }
                    if (this.children.indexOf(focused) == 0) {
                        yield null;
                    }
                    yield ComponentPath.path((ContainerEventHandler)this, (ComponentPath)this.children.get(this.children.indexOf(focused) - 1).nextFocusPath(event));
                }
                case ScreenDirection.RIGHT, ScreenDirection.DOWN -> focused == null ? ComponentPath.path((ContainerEventHandler)this, (ComponentPath)this.children.getFirst().nextFocusPath(event)) : (this.children.indexOf(focused) == this.children.size() - 1 ? null : ComponentPath.path((ContainerEventHandler)this, (ComponentPath)this.children.get(this.children.indexOf(focused) + 1).nextFocusPath(event)));
            };
        }
        return super.nextFocusPath(event);
    }
}

