/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class FloatSlider
extends AbstractSliderButton {
    private final Component baseMessage;
    private final float min;
    private final float max;
    private final boolean onlyValue;
    private final int decimalsToShow;
    private final Consumer<Float> responder;

    public static Builder builder() {
        return new Builder();
    }

    private FloatSlider(int x, int y, int width, int height, Component message, float value, float min, float max, boolean onlyValue, int decimalsToShow, Consumer<Float> responder) {
        super(x, y, width, height, (Component)(onlyValue ? Component.literal((String)FloatSlider.formatValue(Mth.map((float)value, (float)0.0f, (float)1.0f, (float)min, (float)max), decimalsToShow)) : Component.empty().append(message).append(": " + FloatSlider.formatValue(Mth.map((float)value, (float)0.0f, (float)1.0f, (float)min, (float)max), decimalsToShow))), (double)value);
        this.baseMessage = message;
        this.min = min;
        this.max = max;
        this.onlyValue = onlyValue;
        this.decimalsToShow = decimalsToShow;
        this.responder = responder;
    }

    public float floatValue() {
        if (this.decimalsToShow == -1) {
            return (float)Mth.map((double)this.value, (double)0.0, (double)1.0, (double)this.min, (double)this.max);
        }
        return BigDecimal.valueOf((float)Mth.map((double)this.value, (double)0.0, (double)1.0, (double)this.min, (double)this.max)).setScale(this.decimalsToShow, RoundingMode.HALF_UP).floatValue();
    }

    public void setValue(float value) {
        this.value = Mth.clamp((float)Mth.map((float)value, (float)this.min, (float)this.max, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.applyValue();
        this.updateMessage();
    }

    protected void updateMessage() {
        if (this.onlyValue) {
            this.setMessage((Component)Component.literal((String)FloatSlider.formatValue(this.floatValue(), this.decimalsToShow)));
        } else {
            this.setMessage((Component)Component.empty().append(this.baseMessage).append(": " + FloatSlider.formatValue(this.floatValue(), this.decimalsToShow)));
        }
    }

    protected void applyValue() {
        this.responder.accept(Float.valueOf(this.floatValue()));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        float value = this.floatValue();
        boolean pressed = super.keyPressed(keyCode, scanCode, modifiers);
        float modifier = Screen.hasShiftDown() ? this.max / 10.0f : (Screen.hasControlDown() ? this.max / 20.0f : (this.decimalsToShow == -1 ? 0.1f : 1.0f / (float)Math.pow(10.0, this.decimalsToShow)));
        switch (keyCode) {
            case 262: {
                this.setValue(value + modifier);
                break;
            }
            case 263: {
                this.setValue(value - modifier);
            }
        }
        return pressed;
    }

    private static String formatValue(float value, int decimalsToShow) {
        if (decimalsToShow == -1) {
            return String.format("%f", Float.valueOf(value));
        }
        return String.format("%1." + decimalsToShow + "f", Float.valueOf(value));
    }

    public static class Builder {
        private float defaultValue = 0.0f;
        private float min = 0.0f;
        private float max = 1000.0f;
        private boolean onlyValue = false;
        private int decimalsToShow = -1;
        private Consumer<Float> responder = value -> {};

        public Builder bounds(float min, float max) {
            this.min = min;
            this.max = max;
            this.defaultValue = Mth.clamp((float)this.defaultValue, (float)this.min, (float)this.max);
            return this;
        }

        public Builder defaultValue(float defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder displayOnlyValue() {
            this.onlyValue = true;
            return this;
        }

        public Builder decimalsToShow(int decimalsToShow) {
            this.decimalsToShow = decimalsToShow;
            return this;
        }

        public Builder setResponder(Consumer<Float> responder) {
            this.responder = responder;
            return this;
        }

        public FloatSlider create(int x, int y, int width, int height, Component message) {
            return new FloatSlider(x, y, width, height, message, Mth.map((float)Mth.clamp((float)this.defaultValue, (float)this.min, (float)this.max), (float)this.min, (float)this.max, (float)0.0f, (float)1.0f), this.min, this.max, this.onlyValue, this.decimalsToShow, this.responder);
        }
    }
}

