/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui.builder;

import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.DoubleSlider;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import fr.frinn.custommachinery.impl.util.TextureSizeHelper;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ProgressBarGuiElementBuilder
implements IGuiElementBuilder<ProgressBarGuiElement> {
    @Override
    public GuiElementType<ProgressBarGuiElement> type() {
        return Registration.PROGRESS_GUI_ELEMENT.get();
    }

    @Override
    public ProgressBarGuiElement make(AbstractGuiElement.Properties properties, @Nullable ProgressBarGuiElement from) {
        if (from != null) {
            return new ProgressBarGuiElement(properties, from.getEmptyTexture(), from.getFilledTexture(), from.getDirection(), from.getStart(), from.getEnd(), from.getCore() + 1);
        }
        return new ProgressBarGuiElement(properties, ProgressBarGuiElement.BASE_EMPTY_TEXTURE, ProgressBarGuiElement.BASE_FILLED_TEXTURE, ProgressBarGuiElement.Orientation.RIGHT, 0.0f, 0.0f, 1);
    }

    @Override
    public PopupScreen makeConfigPopup(MachineEditScreen parent, MutableProperties properties, @Nullable ProgressBarGuiElement from, Consumer<ProgressBarGuiElement> onFinish) {
        return new ProgressBarGuiElementBuilderPopup((BaseScreen)parent, properties, from, onFinish);
    }

    public static class ProgressBarGuiElementBuilderPopup
    extends GuiElementBuilderPopup<ProgressBarGuiElement> {
        private TextureInfo emptyTexture = ProgressBarGuiElement.BASE_EMPTY_TEXTURE;
        private TextureInfo filledTexture = ProgressBarGuiElement.BASE_FILLED_TEXTURE;
        private ProgressBarGuiElement.Orientation baseOrientation;
        private CycleButton<ProgressBarGuiElement.Orientation> orientation;
        private float start = 0.0f;
        private float end = 1.0f;
        private int core = 1;

        public ProgressBarGuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable ProgressBarGuiElement from, Consumer<ProgressBarGuiElement> onFinish) {
            super(parent, properties, from, onFinish);
            if (from != null) {
                this.emptyTexture = from.getEmptyTexture();
                this.filledTexture = from.getFilledTexture();
                this.start = from.getStart();
                this.end = from.getEnd();
                this.core = from.getCore() + 1;
            }
        }

        @Override
        public ProgressBarGuiElement makeElement() {
            return new ProgressBarGuiElement(this.properties.build(), this.emptyTexture, this.filledTexture, (ProgressBarGuiElement.Orientation)((Object)this.orientation.getValue()), this.start, this.end, this.core);
        }

        @Override
        public void addWidgets(GridLayout.RowHelper row) {
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.empty"), texture -> {
                this.emptyTexture = texture;
            }, this.emptyTexture);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.filled"), texture -> {
                this.filledTexture = texture;
            }, this.filledTexture);
            this.addPriority(row);
            this.baseOrientation = this.baseElement == null ? ProgressBarGuiElement.Orientation.RIGHT : ((ProgressBarGuiElement)this.baseElement).getDirection();
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.progress.orientation"), this.font));
            this.orientation = (CycleButton)row.addChild((LayoutElement)CycleButton.builder(orientation -> Component.literal((String)orientation.toString())).withValues((Object[])ProgressBarGuiElement.Orientation.values()).withInitialValue((Object)this.baseOrientation).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.progress.orientation"), this::changeOrientation));
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.progress.start"), this.font));
            row.addChild((LayoutElement)DoubleSlider.builder().bounds(-1.0, 1.0).defaultValue(this.start).displayOnlyValue().setResponder(value -> {
                this.start = value.floatValue();
            }).create(0, 0, 100, 20, (Component)Component.empty()));
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.progress.end"), this.font));
            row.addChild((LayoutElement)DoubleSlider.builder().bounds(0.0, 2.0).defaultValue(this.end).displayOnlyValue().setResponder(value -> {
                this.end = value.floatValue();
            }).create(0, 0, 100, 20, (Component)Component.empty()));
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.progress.core"), this.font));
            row.addChild((LayoutElement)IntegerSlider.builder().bounds(1, 16).defaultValue(this.core).displayOnlyValue().setResponder(value -> {
                this.core = value;
            }).create(0, 0, 100, 20, (Component)Component.empty()));
        }

        private void changeOrientation(CycleButton<ProgressBarGuiElement.Orientation> button, ProgressBarGuiElement.Orientation orientation) {
            if (this.emptyTexture.equals(ProgressBarGuiElement.BASE_EMPTY_TEXTURE) && this.filledTexture.equals(ProgressBarGuiElement.BASE_FILLED_TEXTURE)) {
                if (!(this.baseOrientation != ProgressBarGuiElement.Orientation.RIGHT && this.baseOrientation != ProgressBarGuiElement.Orientation.LEFT || orientation != ProgressBarGuiElement.Orientation.TOP && orientation != ProgressBarGuiElement.Orientation.BOTTOM)) {
                    this.properties.setWidth(TextureSizeHelper.getTextureHeight(this.emptyTexture.texture()));
                    this.properties.setHeight(TextureSizeHelper.getTextureWidth(this.emptyTexture.texture()));
                } else if (!(this.baseOrientation != ProgressBarGuiElement.Orientation.TOP && this.baseOrientation != ProgressBarGuiElement.Orientation.BOTTOM || orientation != ProgressBarGuiElement.Orientation.RIGHT && orientation != ProgressBarGuiElement.Orientation.LEFT)) {
                    this.properties.setWidth(TextureSizeHelper.getTextureWidth(this.emptyTexture.texture()));
                    this.properties.setHeight(TextureSizeHelper.getTextureHeight(this.emptyTexture.texture()));
                }
            }
        }
    }
}

