/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui.builder;

import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.ComponentEditBox;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import fr.frinn.custommachinery.common.guielement.ButtonGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import java.util.function.Consumer;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ButtonGuiElementBuilder
implements IGuiElementBuilder<ButtonGuiElement> {
    @Override
    public GuiElementType<ButtonGuiElement> type() {
        return Registration.BUTTON_GUI_ELEMENT.get();
    }

    @Override
    public ButtonGuiElement make(AbstractGuiElement.Properties properties, @Nullable ButtonGuiElement from) {
        if (from != null) {
            return new ButtonGuiElement(properties, from.getTextureToggle(), from.getTextureToggleHovered(), from.isToggle(), from.getText(), from.getItem(), from.getHoldTime());
        }
        return new ButtonGuiElement(properties, ButtonGuiElement.BASE_TEXTURE_TOGGLE, ButtonGuiElement.BASE_TEXTURE_TOGGLE_HOVERED, false, (Component)Component.literal((String)""), ItemStack.EMPTY, 1);
    }

    @Override
    public PopupScreen makeConfigPopup(MachineEditScreen parent, MutableProperties properties, @Nullable ButtonGuiElement from, Consumer<ButtonGuiElement> onFinish) {
        return new ButtonGuiElementBuilderPopup((BaseScreen)parent, properties, from, onFinish);
    }

    public static class ButtonGuiElementBuilderPopup
    extends GuiElementBuilderPopup<ButtonGuiElement> {
        private TextureInfo textureToggle = ButtonGuiElement.BASE_TEXTURE_TOGGLE;
        private TextureInfo textureToggleHovered = ButtonGuiElement.BASE_TEXTURE_TOGGLE_HOVERED;
        private Checkbox toggle;
        private ComponentEditBox text;
        private SuggestedEditBox item;
        private IntegerSlider holdTime;

        public ButtonGuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable ButtonGuiElement from, Consumer<ButtonGuiElement> onFinish) {
            super(parent, properties, from, onFinish);
            if (from != null) {
                this.textureToggle = from.getTextureToggle();
                this.textureToggleHovered = from.getTextureToggleHovered();
            }
        }

        private ItemStack getItem() {
            try {
                return ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.item.getValue()))).getDefaultInstance();
            }
            catch (NullPointerException | ResourceLocationException e) {
                return ItemStack.EMPTY;
            }
        }

        @Override
        public ButtonGuiElement makeElement() {
            return new ButtonGuiElement(this.properties.build(), this.textureToggle, this.textureToggleHovered, this.toggle.selected(), this.text.getComponent(), this.getItem(), this.holdTime.intValue());
        }

        @Override
        public Component canCreate() {
            if (this.properties.getId().isEmpty()) {
                return Component.translatable((String)"custommachinery.gui.creation.gui.id.missing");
            }
            return super.canCreate();
        }

        @Override
        public void addWidgets(GridLayout.RowHelper row) {
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.texture"), this.properties::setTexture, this.baseElement != null ? ((ButtonGuiElement)this.baseElement).getTexture() : ButtonGuiElement.BASE_TEXTURE);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.texture_hovered"), this.properties::setTextureHovered, this.baseElement != null ? ((ButtonGuiElement)this.baseElement).getTextureHovered() : ButtonGuiElement.BASE_TEXTURE_HOVERED);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.texture_toggle"), texture -> {
                this.textureToggle = texture;
            }, this.textureToggle);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.texture_toggle_hovered"), texture -> {
                this.textureToggleHovered = texture;
            }, this.textureToggleHovered);
            this.addId(row);
            this.addPriority(row);
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.toggle"), this.font));
            this.toggle = (Checkbox)row.addChild((LayoutElement)Checkbox.builder((Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.toggle"), (Font)this.font).selected(this.baseElement != null && ((ButtonGuiElement)this.baseElement).isToggle()).build());
            this.toggle.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.toggle.tooltip")));
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.text"), this.font));
            this.text = (ComponentEditBox)row.addChild((LayoutElement)new ComponentEditBox(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.text")));
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.item"), this.font));
            this.item = (SuggestedEditBox)row.addChild((LayoutElement)new SuggestedEditBox(this.font, 0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.item"), 5));
            this.item.setFilter(s -> ResourceLocation.tryParse((String)s) != null);
            this.item.addSuggestions(BuiltInRegistries.ITEM.keySet().stream().map(ResourceLocation::toString).toList());
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.hold_time"), this.font));
            this.holdTime = (IntegerSlider)row.addChild((LayoutElement)IntegerSlider.builder().bounds(1, 40).defaultValue(1).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.hold_time")));
            this.holdTime.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.hold_time.tooltip")));
            if (this.baseElement != null) {
                this.text.setComponent(((ButtonGuiElement)this.baseElement).getText());
                this.item.setValue(BuiltInRegistries.ITEM.getKey((Object)((ButtonGuiElement)this.baseElement).getItem().getItem()).toString());
                this.holdTime.setValue(((ButtonGuiElement)this.baseElement).getHoldTime());
            }
        }
    }
}

