/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.RenderTypes;
import fr.frinn.custommachinery.common.config.CMConfig;
import fr.frinn.custommachinery.common.util.CycleTimer;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.neoforged.neoforge.client.model.data.ModelData;

public class StructureRenderer {
    private final int time;
    private final long start;
    private final Function<Direction, Map<BlockPos, IIngredient<PartialBlockState>>> blocksGetter;
    private final CycleTimer timer;

    public StructureRenderer(int time, Function<Direction, Map<BlockPos, IIngredient<PartialBlockState>>> blocksGetter) {
        this.time = time;
        this.start = System.currentTimeMillis();
        this.blocksGetter = blocksGetter;
        this.timer = new CycleTimer((Supplier<Integer>)CMConfig.CONFIG.blockTagCycleTime);
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, Direction direction, Level world, BlockPos machinePos) {
        Map<BlockPos, IIngredient<PartialBlockState>> blocks = this.blocksGetter.apply(direction);
        this.timer.onDraw();
        blocks.forEach((pos, ingredient) -> {
            matrix.pushPose();
            matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            if ((pos.getX() != 0 || pos.getY() != 0 || pos.getZ() != 0) && ingredient != BlockIngredient.ANY) {
                PartialBlockState state = (PartialBlockState)this.timer.get(ingredient.getAll());
                BlockPos blockPos = machinePos.offset((Vec3i)pos);
                if (state != null && state != PartialBlockState.ANY && !state.getBlockState().isAir()) {
                    if (world.getBlockState(blockPos).isAir()) {
                        this.renderTransparentBlock(state, matrix, buffer);
                    } else if (ingredient.getAll().stream().noneMatch(test -> test.test(new BlockInWorld((LevelReader)world, blockPos, false)))) {
                        this.renderNope(matrix, buffer);
                    }
                }
            }
            matrix.popPose();
        });
    }

    private void renderTransparentBlock(PartialBlockState state, PoseStack matrix, MultiBufferSource buffer) {
        VertexConsumer builder = buffer.getBuffer(RenderTypes.PHANTOM);
        matrix.translate(0.1f, 0.1f, 0.1f);
        matrix.scale(0.8f, 0.8f, 0.8f);
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state.getBlockState());
        if (model != Minecraft.getInstance().getModelManager().getMissingModel()) {
            Arrays.stream(Direction.values()).flatMap(direction -> model.getQuads(state.getBlockState(), direction, RandomSource.create((long)42L)).stream()).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
            model.getQuads(state.getBlockState(), null, RandomSource.create((long)42L)).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
        }
    }

    private void renderNope(PoseStack matrix, MultiBufferSource buffer) {
        VertexConsumer builder = buffer.getBuffer(RenderTypes.NOPE);
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)CustomMachinery.rl("block/nope")));
        matrix.translate(-5.0E-4, -5.0E-4, -5.0E-4);
        matrix.scale(1.001f, 1.001f, 1.001f);
        Arrays.stream(Direction.values()).flatMap(direction -> model.getQuads(null, direction, RandomSource.create((long)42L), ModelData.EMPTY, null).stream()).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 0.8f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
        model.getQuads(null, null, RandomSource.create((long)42L), ModelData.EMPTY, null).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 0.8f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
    }

    public boolean shouldRender() {
        return System.currentTimeMillis() < this.start + (long)this.time;
    }
}

