/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.event;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.IBreakAttemptResult;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockBreakEventWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockPosWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockStateWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.LevelWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.PlayerWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ServerLevelWrapper;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class BlockBreakListener {
    @NotNull
    private final FallingTreeCommon<?> mod;

    @SubscribeEvent
    public void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        Optional optionalPos = event.getPosition();
        if (optionalPos.isEmpty()) {
            return;
        }
        PlayerWrapper wrappedPlayer = new PlayerWrapper(event.getEntity());
        BlockPosWrapper wrappedPos = new BlockPosWrapper((BlockPos)optionalPos.get());
        BlockStateWrapper wrappedState = new BlockStateWrapper(event.getState());
        Optional<Float> result = this.mod.getTreeHandler().getBreakSpeed(wrappedPlayer, wrappedPos, wrappedState, event.getNewSpeed());
        if (result.isEmpty()) {
            return;
        }
        event.setNewSpeed(result.get().floatValue());
    }

    @SubscribeEvent
    public void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        LevelWrapper levelWrapper;
        if (event.isCanceled()) {
            return;
        }
        if (this.mod.isOwnEvent(new BlockBreakEventWrapper(event))) {
            return;
        }
        PlayerWrapper wrappedPlayer = new PlayerWrapper(event.getPlayer());
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            levelWrapper = new ServerLevelWrapper(serverLevel);
        } else {
            levelWrapper = new LevelWrapper(event.getLevel());
        }
        LevelWrapper wrappedLevel = levelWrapper;
        BlockPosWrapper wrappedPos = new BlockPosWrapper(event.getPos());
        BlockStateWrapper wrappedState = new BlockStateWrapper(event.getState());
        IBlockEntity wrappedEntity = wrappedLevel.getBlockEntity(wrappedPos);
        if (this.mod.getTreeHandler().shouldCancelEvent(wrappedLevel, wrappedPlayer, wrappedPos, wrappedState, wrappedEntity)) {
            event.setCanceled(true);
            return;
        }
        IBreakAttemptResult result = this.mod.getTreeHandler().breakTree(event.isCancelable(), wrappedLevel, wrappedPlayer, wrappedPos, wrappedState, wrappedEntity);
        if (result.shouldCancel()) {
            event.setCanceled(true);
        }
    }

    @Generated
    public BlockBreakListener(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

