/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree;

import fr.rakambda.fallingtree.common.tree.TreePart;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Tree {
    @NotNull
    private final ILevel level;
    @NotNull
    private final IBlockPos hitPos;
    private final Set<TreePart> parts = new LinkedHashSet<TreePart>();
    private final Map<TreePartType, Integer> partCounts = new LinkedHashMap<TreePartType, Integer>();

    public void addPart(@NotNull TreePart treePart) {
        this.parts.add(treePart);
        this.partCounts.compute(treePart.treePartType(), (key, value) -> {
            if (Objects.isNull(value)) {
                return 1;
            }
            return value + 1;
        });
    }

    public void removePartsHigherThan(int y, @NotNull TreePartType partType) {
        this.parts.removeIf(part -> {
            if (part.treePartType() == partType && part.blockPos().getY() > y) {
                this.decrementPartCount(partType);
                return true;
            }
            return false;
        });
    }

    public int getBreakableCount() {
        return Arrays.stream(TreePartType.getValues()).filter(TreePartType::isBreakable).mapToInt(this::getPartCount).sum();
    }

    private int getPartCount(@NotNull TreePartType treePartType) {
        return this.partCounts.computeIfAbsent(treePartType, key -> 0);
    }

    public int getSize() {
        return this.partCounts.values().stream().mapToInt(i -> i).sum();
    }

    private void decrementPartCount(@NotNull TreePartType partType) {
        this.partCounts.computeIfPresent(partType, (type, count) -> Math.max(0, count - 1));
    }

    @NotNull
    public Optional<TreePart> getLastSequencePart() {
        return this.getParts().stream().max(Comparator.comparingInt(TreePart::sequence));
    }

    @NotNull
    public Optional<TreePart> getLastSequenceLogPart() {
        return this.getParts().stream().filter(part -> part.treePartType().isLog()).max(Comparator.comparingInt(TreePart::sequence));
    }

    @NotNull
    public Collection<TreePart> getBreakableLogs() {
        return this.getParts().stream().filter(part -> part.treePartType().isLog()).filter(part -> part.treePartType().isBreakable()).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<TreePart> getBreakableParts() {
        return this.getParts().stream().filter(part -> part.treePartType().isBreakable()).collect(Collectors.toSet());
    }

    public int getLogCount() {
        return this.getPartCount(TreePartType.LOG);
    }

    @NotNull
    public Optional<IBlockPos> getTopMostLog() {
        return this.getBreakableLogs().stream().map(TreePart::blockPos).max(Comparator.comparingInt(IBlockPos::getY));
    }

    @NotNull
    public Optional<IBlockPos> getBottomMostLog() {
        return this.getBreakableLogs().stream().map(TreePart::blockPos).min(Comparator.comparingInt(IBlockPos::getY));
    }

    @NotNull
    private Optional<IBlockPos> getTopMostPart() {
        return this.getParts().stream().map(TreePart::blockPos).max(Comparator.comparingInt(IBlockPos::getY));
    }

    @NotNull
    public Collection<TreePart> getNetherWarts() {
        return this.getParts().stream().filter(part -> part.treePartType() == TreePartType.NETHER_WART).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<TreePart> getMangroveRoots() {
        return this.getParts().stream().filter(part -> part.treePartType() == TreePartType.MANGROVE_ROOTS).collect(Collectors.toSet());
    }

    @NotNull
    public Optional<TreePart> getStart() {
        return this.getParts().stream().filter(part -> part.treePartType() == TreePartType.LOG_START).findFirst();
    }

    @Generated
    public Tree(@NotNull ILevel level, @NotNull IBlockPos hitPos) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (hitPos == null) {
            throw new NullPointerException("hitPos is marked non-null but is null");
        }
        this.level = level;
        this.hitPos = hitPos;
    }

    @NotNull
    @Generated
    public ILevel getLevel() {
        return this.level;
    }

    @NotNull
    @Generated
    public IBlockPos getHitPos() {
        return this.hitPos;
    }

    @Generated
    public Set<TreePart> getParts() {
        return this.parts;
    }
}

