/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2.stack;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.Action;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MekanismStackExportStrategy
implements StackExportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MekanismStackExportStrategy.class);
    private final BlockCapabilityCache<IChemicalHandler, Direction> cache;

    public MekanismStackExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create(MekCapabilities.CHEMICAL.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public long transfer(StackTransferContext context, AEKey what, long amount) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey mekanismKey = (MekanismKey)what;
        IChemicalHandler storage = (IChemicalHandler)this.cache.getCapability();
        if (storage == null) {
            return 0L;
        }
        IStorageService inv = context.getInternalStorage();
        long extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE);
        long wasInserted = extracted - storage.insertChemical(mekanismKey.withAmount(extracted), Action.SIMULATE).getAmount();
        if (wasInserted > 0L && (wasInserted = (extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)wasInserted, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE)) - storage.insertChemical(mekanismKey.withAmount(extracted), Action.EXECUTE).getAmount()) < extracted) {
            long leftover = extracted - wasInserted;
            if ((leftover -= inv.getInventory().insert(what, leftover, Actionable.MODULATE, context.getActionSource())) > 0L) {
                LOGGER.error("Storage export: adjacent block unexpectedly refused insert, voided {}x{}", (Object)leftover, (Object)what);
            }
        }
        return wasInserted;
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey mekanismKey = (MekanismKey)what;
        IChemicalHandler storage = (IChemicalHandler)this.cache.getCapability();
        if (storage == null) {
            return 0L;
        }
        return amount - storage.insertChemical(mekanismKey.withAmount(amount), Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
    }
}

