/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMode;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipe;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipeInput;
import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import com.github.minecraftschurlimods.bibliocraft.util.StringRepresentableEnum;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PrintingTableMergingRecipe
extends PrintingTableRecipe {
    public static final MapCodec<PrintingTableMergingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.unboundedMap((Codec)BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec(), (Codec)Codec.unboundedMap((Codec)Codec.STRING, MergeMethod.CODEC)).fieldOf("component_mergers").forGetter(e -> e.mergers), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(e -> e.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(e -> e.result), (App)Codec.INT.fieldOf("duration").forGetter(e -> e.duration)).apply((Applicative)inst, PrintingTableMergingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PrintingTableMergingRecipe> STREAM_CODEC = StreamCodec.composite(CodecUtil.mapStreamCodec(ByteBufCodecs.registry((ResourceKey)Registries.DATA_COMPONENT_TYPE), CodecUtil.mapStreamCodec(ByteBufCodecs.STRING_UTF8, MergeMethod.STREAM_CODEC)), e -> e.mergers, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, e -> e.ingredient, (StreamCodec)ItemStack.STREAM_CODEC, e -> e.result, (StreamCodec)ByteBufCodecs.INT, e -> e.duration, PrintingTableMergingRecipe::new);
    private final Map<DataComponentType<?>, Map<String, MergeMethod>> mergers;
    private final Ingredient ingredient;

    public PrintingTableMergingRecipe(Map<DataComponentType<?>, Map<String, MergeMethod>> mergers, Ingredient ingredient, ItemStack result, int duration) {
        super(result, duration);
        this.mergers = mergers;
        this.ingredient = ingredient;
    }

    @Override
    public PrintingTableMode getMode() {
        return PrintingTableMode.MERGE;
    }

    public boolean matches(PrintingTableRecipeInput input, Level level) {
        ItemStack right = input.right();
        if (!this.ingredient.test(right)) {
            return false;
        }
        ArrayList<ItemStack> left = new ArrayList<ItemStack>(input.left());
        left.removeIf(ItemStack::isEmpty);
        if (left.size() < 2) {
            return false;
        }
        return left.stream().allMatch(stack -> {
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.result)) return false;
            if (!this.mergers.keySet().stream().allMatch(arg_0 -> ((ItemStack)stack).has(arg_0))) return false;
            return true;
        });
    }

    public ItemStack assemble(PrintingTableRecipeInput input, HolderLookup.Provider registries) {
        ItemStack result = input.right().copy();
        List<Map<DataComponentType<?>, JsonObject>> jsons = input.left().stream().filter(e -> !e.isEmpty()).map(stack -> Map.ofEntries((Map.Entry[])stack.getComponents().keySet().stream().filter(type -> type.codec() != null).map(type -> PrintingTableMergingRecipe.mapToJson(type, stack)).filter(Objects::nonNull).toArray(Map.Entry[]::new))).toList();
        for (DataComponentType<?> type : this.mergers.keySet()) {
            JsonObject json = new JsonObject();
            for (String key : this.mergers.get(type).keySet()) {
                MergeMethod merger = this.getMerger(type, key, jsons);
                json.add(key, (JsonElement)(switch (merger.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> jsons.getFirst().get(type).get(key);
                    case 1 -> jsons.getLast().get(type).get(key);
                    case 2 -> new JsonPrimitive((Number)jsons.stream().mapToInt(e -> ((JsonObject)e.get(type)).get(key).getAsInt()).min().orElseThrow());
                    case 3 -> new JsonPrimitive((Number)jsons.stream().mapToInt(e -> ((JsonObject)e.get(type)).get(key).getAsInt()).max().orElseThrow());
                    case 4 -> {
                        JsonArray array = new JsonArray();
                        jsons.stream().map(e -> ((JsonObject)e.get(type)).get(key).getAsJsonArray().asList()).flatMap(Collection::stream).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                        yield array;
                    }
                }));
            }
            PrintingTableMergingRecipe.setFromJson(type, result, json);
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return BCRecipes.PRINTING_TABLE_MERGING.get();
    }

    public NonNullList<ItemStack> getRemainingItems(PrintingTableRecipeInput input) {
        NonNullList remainingItems = super.getRemainingItems((RecipeInput)input);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = input.left().get(i);
            if (stack.isEmpty()) continue;
            remainingItems.set(i, (Object)stack.copy());
        }
        return remainingItems;
    }

    @Override
    public Pair<List<Ingredient>, Ingredient> getDisplayIngredients() {
        Ingredient input = Ingredient.of((ItemStack[])new ItemStack[]{this.result.copy()});
        return Pair.of(List.of(input, input), (Object)this.ingredient);
    }

    private MergeMethod getMerger(DataComponentType<?> type, String key, List<Map<DataComponentType<?>, JsonObject>> jsons) {
        MergeMethod merger = this.mergers.get(type).get(key);
        if (merger == null) {
            return jsons.stream().allMatch(e -> ((JsonObject)e.get(type)).get(key).isJsonArray()) ? MergeMethod.APPEND : MergeMethod.FIRST;
        }
        if (merger == MergeMethod.MIN || merger == MergeMethod.MAX) {
            return jsons.stream().allMatch(e -> PrintingTableMergingRecipe.isJsonNumber(((JsonObject)e.get(type)).get(key))) ? merger : MergeMethod.FIRST;
        }
        return merger;
    }

    private static boolean isJsonNumber(JsonElement json) {
        return json != null && json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber();
    }

    @Nullable
    private static <T> Map.Entry<DataComponentType<T>, JsonObject> mapToJson(DataComponentType<T> type, ItemStack stack) {
        JsonElement json = CodecUtil.encodeJson(BCUtil.nonNull(type.codec()), stack.get(type));
        return json.isJsonObject() ? Map.entry(type, json.getAsJsonObject()) : null;
    }

    private static <T> void setFromJson(DataComponentType<T> type, ItemStack stack, JsonObject json) {
        stack.set(type, CodecUtil.decodeJson(BCUtil.nonNull(type.codec()), (JsonElement)json));
    }

    public static enum MergeMethod implements StringRepresentableEnum
    {
        FIRST,
        LAST,
        MIN,
        MAX,
        APPEND;

        public static final Codec<MergeMethod> CODEC;
        public static final StreamCodec<ByteBuf, MergeMethod> STREAM_CODEC;

        static {
            CODEC = CodecUtil.enumCodec(MergeMethod::values);
            STREAM_CODEC = CodecUtil.enumStreamCodec(MergeMethod::values, Enum::ordinal);
        }
    }

    public static class Builder
    extends PrintingTableRecipe.Builder {
        private final Map<DataComponentType<?>, Map<String, MergeMethod>> mergers = new HashMap();
        private final Ingredient ingredient;

        public Builder(Ingredient ingredient, ItemStack result, int duration) {
            super(result, duration);
            this.ingredient = ingredient;
        }

        public Builder addMerger(DataComponentType<?> type, String key, MergeMethod method) {
            this.mergers.putIfAbsent(type, new HashMap());
            this.mergers.get(type).put(key, method);
            return this;
        }

        @Override
        public PrintingTableRecipe build() {
            return new PrintingTableMergingRecipe(this.mergers, this.ingredient, this.result, this.duration);
        }
    }
}

