/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterPage;
import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.init.BCSoundEvents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class TypewriterScreen
extends Screen {
    public static final int IMAGE_WIDTH = 100;
    public static final int IMAGE_HEIGHT = 144;
    private static final ResourceLocation BACKGROUND = BCUtil.bcLoc("textures/gui/typewriter_page.png");
    private final RandomSource random = RandomSource.create((long)Util.getNanos());
    private final BlockPos pos;
    private TypewriterPage page;
    private int leftPos;
    private int topPos;
    private int row;
    private String currentLine;
    private int frameTick;
    private boolean hasPendingSound = false;

    public TypewriterScreen(BlockPos pos) {
        super(Translations.TYPEWRITER_TITLE);
        TypewriterPage typewriterPage;
        this.pos = pos;
        BlockEntity blockEntity = ClientUtil.getLevel().getBlockEntity(pos);
        if (blockEntity instanceof TypewriterBlockEntity) {
            TypewriterBlockEntity typewriter = (TypewriterBlockEntity)blockEntity;
            typewriterPage = typewriter.getPage();
        } else {
            typewriterPage = TypewriterPage.DEFAULT;
        }
        this.page = typewriterPage;
        this.row = this.page.line();
        if (this.row == 14) {
            this.onClose();
        } else {
            this.currentLine = this.page.lines().get(this.row);
        }
    }

    protected void init() {
        this.leftPos = (this.width - 100) / 2;
        this.topPos = (this.height - 144) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(this.width / 2 - 100, this.topPos + 144 + 4, 200, 20).build());
    }

    public void tick() {
        super.tick();
        ++this.frameTick;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.sync();
        super.onClose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        Font font = ClientUtil.getFont();
        for (int i = 0; i < this.row; ++i) {
            if (i >= this.page.lines().size()) continue;
            graphics.drawString(font, this.page.lines().get(i), this.leftPos + 2, this.topPos + 2 + i * 10, 0, false);
        }
        if (this.row < 14) {
            int width = graphics.drawString(font, this.currentLine, this.leftPos + 2, this.topPos + 2 + this.row * 10, 0, false);
            if (this.frameTick / 6 % 2 == 0) {
                graphics.drawString(font, "_", width, this.topPos + 2 + this.row * 10, 0, false);
            }
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, 100, 144);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.lineBreak();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (StringUtil.isAllowedChatCharacter((char)codePoint)) {
            this.currentLine = this.currentLine + codePoint;
            if (this.currentLine.length() >= 16) {
                this.lineBreak();
            } else {
                ClientUtil.getPlayer().playSound((SoundEvent)BCSoundEvents.TYPEWRITER_TYPE.value(), 0.9f + this.random.nextFloat() * 0.2f, 0.9f + this.random.nextFloat() * 0.2f);
            }
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    private void sync() {
        BlockEntity blockEntity;
        this.page = this.page.copy().withLine(this.row);
        if (this.row < this.page.lines().size()) {
            this.page.lines().set(this.row, this.currentLine);
        }
        if ((blockEntity = ClientUtil.getLevel().getBlockEntity(this.pos)) instanceof TypewriterBlockEntity) {
            TypewriterBlockEntity typewriter = (TypewriterBlockEntity)blockEntity;
            typewriter.setPage(this.page);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new TypewriterSyncPacket(this.pos, this.page, this.hasPendingSound), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.hasPendingSound) {
            ClientUtil.getPlayer().playSound((SoundEvent)BCSoundEvents.TYPEWRITER_CHIME.value());
            this.hasPendingSound = false;
        }
    }

    private void lineBreak() {
        this.page = this.page.copy();
        this.page.lines().set(this.row, this.currentLine);
        this.currentLine = "";
        ++this.row;
        this.hasPendingSound = true;
        if (this.row >= 14) {
            this.onClose();
        } else {
            this.sync();
        }
    }
}

