/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityLavaFactoryController
extends TileEntityBase
implements IEnergyDisplay {
    public static final int NOT_MULTI = 0;
    public static final int HAS_LAVA = 1;
    public static final int HAS_AIR = 2;
    public static final int ENERGY_USE = 150000;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(300000, 2000, 0);
    private int currentWorkTime;
    private int oldEnergy;

    public TileEntityLavaFactoryController(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.LAVA_FACTORY_CONTROLLER.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("WorkTime", this.currentWorkTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentWorkTime = compound.getInt("WorkTime");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLavaFactoryController) {
            TileEntityLavaFactoryController tile = (TileEntityLavaFactoryController)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLavaFactoryController) {
            TileEntityLavaFactoryController tile = (TileEntityLavaFactoryController)t;
            tile.serverTick();
            if (tile.storage.getEnergyStored() >= 150000 && tile.isMultiblock() == 2) {
                ++tile.currentWorkTime;
                if (tile.currentWorkTime >= 200) {
                    tile.currentWorkTime = 0;
                    level.setBlock(tile.worldPosition.above(), Blocks.LAVA.defaultBlockState(), 2);
                    tile.storage.extractEnergyInternal(150000, false);
                }
            } else {
                tile.currentWorkTime = 0;
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    public int isMultiblock() {
        BlockPos thisPos = this.worldPosition;
        BlockPos[] positions = new BlockPos[]{thisPos.offset(1, 1, 0), thisPos.offset(-1, 1, 0), thisPos.offset(0, 1, 1), thisPos.offset(0, 1, -1)};
        if (this.level != null && WorldUtil.hasBlocksInPlacesGiven(positions, ActuallyBlocks.LAVA_FACTORY_CASING.get(), this.level)) {
            BlockPos pos = thisPos.above();
            BlockState state = this.level.getBlockState(pos);
            Block block = state.getBlock();
            if (block == Blocks.LAVA) {
                return 1;
            }
            if (this.level.isEmptyBlock(pos)) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }
}

