/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network.handler;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.packet.SpawnLaserPacket;
import de.ellpeck.actuallyadditions.mod.network.packet.SpawnLaserParticlePacket;
import de.ellpeck.actuallyadditions.mod.network.packet.SyncPlayerPacket;
import de.ellpeck.actuallyadditions.mod.network.packet.TileUpdatePacket;
import de.ellpeck.actuallyadditions.mod.particle.ParticleLaserItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSpawnLaser(SpawnLaserPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound()) {
                AssetUtil.spawnLaserWithTimeClient(packet.startX(), packet.startY(), packet.startZ(), packet.endX(), packet.endY(), packet.endZ(), packet.color(), packet.maxAge(), packet.rotationTime(), packet.size(), packet.alpha());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.spawn_laser.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSpawnLaserParticle(SpawnLaserParticlePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            if (context.flow().isClientbound() && (player = context.player()) != null) {
                ItemStack stack = packet.stack();
                BlockPos in = packet.in();
                double inX = (double)in.getX() + 0.5;
                double inY = (double)in.getY() + 0.78;
                double inZ = (double)in.getZ() + 0.5;
                BlockPos out = packet.out();
                double outX = (double)out.getX() + 0.5;
                double outY = (double)out.getY() + 0.525;
                double outZ = (double)out.getZ() + 0.5;
                player.level().addParticle(ParticleLaserItem.Factory.createData(stack, inX, inY, inZ), outX, outY, outZ, 0.0, 0.025, 0.0);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.spawn_laser_particle.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleTileUpdate(TileUpdatePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity tile;
            Player player;
            if (context.flow().isClientbound() && (player = context.player()) != null && (tile = player.level().getBlockEntity(packet.pos())) instanceof TileEntityBase) {
                TileEntityBase tileBase = (TileEntityBase)tile;
                tileBase.readSyncableNBT(packet.data(), (HolderLookup.Provider)player.registryAccess(), TileEntityBase.NBTType.SYNC);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.tile_update.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSyncPlayer(SyncPlayerPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound()) {
                Player player = context.player();
                CompoundTag tag = packet.tag();
                CompoundTag dataTag = tag.getCompound("Data");
                if (player != null) {
                    PlayerData.getDataFromPlayer(player).readFromNBT(dataTag, false);
                    if (tag.getBoolean("Log")) {
                        ActuallyAdditions.LOGGER.info("Receiving (new or changed) Player Data for player {}.", (Object)player.getName());
                    }
                } else {
                    ActuallyAdditions.LOGGER.error("Tried to receive Player Data for the current player, but he doesn't seem to be present!");
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.sync_player_client.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

