/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityRangedCollector;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerRangedCollector
extends AbstractContainerMenu {
    public final TileEntityRangedCollector collector;

    public static ContainerRangedCollector fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerRangedCollector(windowId, inv, (TileEntityRangedCollector)Objects.requireNonNull(inv.player.level().getBlockEntity(data.readBlockPos())));
    }

    public ContainerRangedCollector(int windowId, Inventory inventory, TileEntityRangedCollector tile) {
        super(ActuallyContainers.RANGED_COLLECTOR_CONTAINER.get(), windowId);
        int j;
        int i;
        this.collector = tile;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.collector.inv, j + i * 3, 96 + j * 18, 24 + i * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot((Slot)new SlotFilter(this.collector.filter, j + i * 3, 20 + j * 18, 6 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 90 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 148));
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slot) {
        int inventoryStart = 18;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot >= inventoryStart ? !this.moveItemStackTo(newStack, 0, 6, false) && (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false)) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (SlotFilter.checkFilter(this, slotId, player)) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.collector.canPlayerUse(player);
    }
}

