/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class EmpowererRecipe
implements Recipe<RecipeInput> {
    public static String NAME = "empowering";
    protected final Ingredient input;
    protected final ItemStack output;
    protected final NonNullList<Ingredient> modifiers;
    protected final int energyPerStand;
    protected final int particleColor;
    protected final int time;

    public EmpowererRecipe(ItemStack output, Ingredient input, NonNullList<Ingredient> modifiers, int energyPerStand, int particleColor, int time) {
        this.input = input;
        this.output = output;
        this.modifiers = modifiers;
        this.energyPerStand = energyPerStand;
        this.particleColor = particleColor;
        this.time = time;
    }

    public boolean matches(ItemStack base, ItemStack stand1, ItemStack stand2, ItemStack stand3, ItemStack stand4) {
        if (!this.input.test(base) || stand1.isEmpty() || stand2.isEmpty() || stand3.isEmpty() || stand4.isEmpty()) {
            return false;
        }
        ArrayList<Ingredient> matches = new ArrayList<Ingredient>();
        ItemStack[] stacks = new ItemStack[]{stand1, stand2, stand3, stand4};
        boolean[] unused = new boolean[]{true, true, true, true};
        for (ItemStack s : stacks) {
            if (unused[0] && ((Ingredient)this.modifiers.get(0)).test(s)) {
                matches.add((Ingredient)this.modifiers.getFirst());
                unused[0] = false;
                continue;
            }
            if (unused[1] && ((Ingredient)this.modifiers.get(1)).test(s)) {
                matches.add((Ingredient)this.modifiers.get(1));
                unused[1] = false;
                continue;
            }
            if (unused[2] && ((Ingredient)this.modifiers.get(2)).test(s)) {
                matches.add((Ingredient)this.modifiers.get(2));
                unused[2] = false;
                continue;
            }
            if (!unused[3] || !((Ingredient)this.modifiers.get(3)).test(s)) continue;
            matches.add((Ingredient)this.modifiers.get(3));
            unused[3] = false;
        }
        return matches.size() == 4;
    }

    public boolean matches(@Nonnull RecipeInput pInv, @Nonnull Level pLevel) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput pInv, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.EMPOWERING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.EMPOWERING.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public Ingredient getStandOne() {
        return (Ingredient)this.modifiers.getFirst();
    }

    public Ingredient getStandTwo() {
        return (Ingredient)this.modifiers.get(1);
    }

    public Ingredient getStandThree() {
        return (Ingredient)this.modifiers.get(2);
    }

    public Ingredient getStandFour() {
        return (Ingredient)this.modifiers.get(3);
    }

    public int getTime() {
        return this.time;
    }

    public int getEnergyPerStand() {
        return this.energyPerStand;
    }

    public int getParticleColors() {
        return this.particleColor;
    }

    public static class Serializer
    implements RecipeSerializer<EmpowererRecipe> {
        private static final MapCodec<EmpowererRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("base").forGetter(recipe -> recipe.input), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("modifiers").flatXmap(list -> {
            Object[] aingredient = (Ingredient[])list.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No modifiers for Empowering recipe");
            }
            return aingredient.length != 4 ? DataResult.error(() -> Serializer.lambda$static$4((Ingredient[])aingredient)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.modifiers), (App)Codec.INT.fieldOf("energy").forGetter(recipe -> recipe.energyPerStand), (App)Codec.INT.fieldOf("color").forGetter(recipe -> recipe.particleColor), (App)Codec.INT.fieldOf("time").forGetter(recipe -> recipe.time)).apply((Applicative)instance, EmpowererRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EmpowererRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<EmpowererRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EmpowererRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static EmpowererRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            int i = pBuffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
            }
            int energy = pBuffer.readInt();
            int color = pBuffer.readInt();
            int time = pBuffer.readInt();
            return new EmpowererRecipe(result, input, (NonNullList<Ingredient>)nonnulllist, energy, color, time);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, EmpowererRecipe pRecipe) {
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.input);
            pBuffer.writeVarInt(pRecipe.modifiers.size());
            for (Ingredient modifier : pRecipe.modifiers) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)modifier);
            }
            pBuffer.writeInt(pRecipe.energyPerStand);
            pBuffer.writeInt(pRecipe.particleColor);
            pBuffer.writeInt(pRecipe.time);
        }

        private static /* synthetic */ String lambda$static$4(Ingredient[] aingredient) {
            return "Must have exactly 4 modifiers. has: %s".formatted(aingredient.length);
        }
    }
}

