/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.parts.IPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.util.Platform;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.glodium.util.GlodCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemMEPackingTape
extends Item {
    private static final ObjectSet<ResourceLocation> WHITE_LIST = new ObjectOpenHashSet();

    public ItemMEPackingTape() {
        super(new Item.Properties().durability(64));
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockEntity tile = world.getBlockEntity(pos);
        Player player = context.getPlayer();
        ItemStack pack = new ItemStack((ItemLike)EAESingletons.PACKAGE);
        boolean success = false;
        if (tile != null && player != null) {
            if (tile instanceof CableBusBlockEntity) {
                CableBusBlockEntity cable = (CableBusBlockEntity)tile;
                Vec3 hitVec = context.getClickLocation();
                Vec3 hitInBlock = new Vec3(hitVec.x - (double)pos.getX(), hitVec.y - (double)pos.getY(), hitVec.z - (double)pos.getZ());
                IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
                if (part != null) {
                    pack.set(EAESingletons.IS_PART, (Object)true);
                    Item partItem = part.getPartItem().asItem();
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)partItem);
                    if (!WHITE_LIST.contains((Object)id)) {
                        return InteractionResult.PASS;
                    }
                    CompoundTag ctxTag = new CompoundTag();
                    part.writeToNBT(ctxTag, (HolderLookup.Provider)world.registryAccess());
                    pack.set(EAESingletons.TAPE_PART_DATA, (Object)new PartPackageData(id, ctxTag));
                    cable.removePart(part);
                    success = true;
                }
            } else {
                pack.set(EAESingletons.IS_PART, (Object)false);
                BlockState state = tile.getBlockState();
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                if (!WHITE_LIST.contains((Object)blockId)) {
                    return InteractionResult.PASS;
                }
                ResourceLocation id = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)tile.getType());
                CompoundTag ctxTag = tile.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                pack.set(EAESingletons.TAPE_TILE_DATA, (Object)new TilePackageData(id, blockId, NbtUtils.writeBlockState((BlockState)state), ctxTag));
                world.removeBlockEntity(pos);
                world.removeBlock(pos, false);
                success = true;
            }
            if (success) {
                Platform.spawnDrops((Level)world, (BlockPos)pos, Collections.singletonList(pack));
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public static void registerPackableDevice(ResourceLocation id) {
        WHITE_LIST.add((Object)id);
    }

    public record PartPackageData(ResourceLocation id, CompoundTag context) {
        public static final Codec<PartPackageData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(o -> o.id), (App)CompoundTag.CODEC.fieldOf("ctx").forGetter(o -> o.context)).apply((Applicative)builder, PartPackageData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PartPackageData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, o -> o.id, (StreamCodec)GlodCodecs.NBT_STREAM_CODEC, o -> o.context, PartPackageData::new);
    }

    public record TilePackageData(ResourceLocation id, ResourceLocation block, CompoundTag state, CompoundTag context) {
        public static final Codec<TilePackageData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(o -> o.id), (App)ResourceLocation.CODEC.fieldOf("block_id").forGetter(o -> o.block), (App)CompoundTag.CODEC.fieldOf("state").forGetter(o -> o.state), (App)CompoundTag.CODEC.fieldOf("ctx").forGetter(o -> o.context)).apply((Applicative)builder, TilePackageData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TilePackageData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, o -> o.id, (StreamCodec)ResourceLocation.STREAM_CODEC, o -> o.block, (StreamCodec)GlodCodecs.NBT_STREAM_CODEC, o -> o.state, (StreamCodec)GlodCodecs.NBT_STREAM_CODEC, o -> o.context, TilePackageData::new);
    }
}

