/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.PlanService;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.PlanInfoPanel;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectJarStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectPackageStep;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SelectPlanTypeStep
extends ProcessStep {
    private PlanInfoPanel premiumInfoPanel;
    private PlanInfoPanel budgetInfoPanel;
    private final Component choosePlan = Component.translatable((String)"step.select_plan.choose_plan");

    public SelectPlanTypeStep(OrderData orderData) {
        super(orderData);
        orderData.isPremium = true;
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiEventListener> children) {
        super.init(screen, children);
        int y0 = Math.max(74, screen.height / 2 - 50);
        int y1 = Math.min(screen.height - 80, screen.height / 2 + 50);
        this.premiumInfoPanel = new PlanInfoPanel(screen.getMinecraft(), screen.width / 2 - 20, y1 - y0, y0, 10, (PlanService)ApiData.PLANS.getLeft());
        this.budgetInfoPanel = new PlanInfoPanel(screen.getMinecraft(), screen.width / 2 - 20, y1 - y0, y0, screen.width / 2 + 10, (PlanService)ApiData.PLANS.getRight());
        Button premiumButton = Button.builder((Component)Component.translatable((String)"step.select_plan.choose_premium"), b -> {
            this.orderData.isPremium = true;
            screen.setStep(new SelectPackageStep(this.orderData));
        }).pos(this.premiumInfoPanel.getLeft() + (this.premiumInfoPanel.getWidth() - 120) / 2, this.premiumInfoPanel.getBottom() + 8).width(120).build();
        Button budgetButton = Button.builder((Component)Component.translatable((String)"step.select_plan.choose_budget"), b -> {
            this.orderData.isPremium = false;
            screen.setStep(new SelectPackageStep(this.orderData));
        }).pos(this.budgetInfoPanel.getLeft() + (this.budgetInfoPanel.getWidth() - 120) / 2, this.budgetInfoPanel.getBottom() + 8).width(120).build();
        children.accept((GuiEventListener)premiumButton);
        children.accept((GuiEventListener)budgetButton);
        children.accept((GuiEventListener)this.premiumInfoPanel);
        children.accept((GuiEventListener)this.budgetInfoPanel);
    }

    @Override
    public void renderLast(BHOrderScreen screen, Font font, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderLast(screen, font, graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void render(BHOrderScreen screen, Font font, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.premiumInfoPanel.render(graphics, mouseX, mouseY, partialTicks);
        this.budgetInfoPanel.render(graphics, mouseX, mouseY, partialTicks);
        PlanService premium = (PlanService)ApiData.PLANS.getLeft();
        PlanService budget = (PlanService)ApiData.PLANS.getRight();
        Component premiumName = ModRef.getTranslatableOrElse("step.select_plan.premium_name", premium.name);
        Component budgetName = ModRef.getTranslatableOrElse("step.select_plan.budget_name", budget.name);
        graphics.pose().pushPose();
        float scale = 1.5f;
        graphics.pose().scale(scale, scale, scale);
        int x = (int)(((float)screen.width - (float)font.width((FormattedText)this.choosePlan) * scale) / 2.0f / scale);
        int y = (int)(((float)this.premiumInfoPanel.getTop() - 25.0f * scale) / scale);
        graphics.drawString(font, this.choosePlan, x, y, 0xFFFFFF);
        x = (int)(((float)this.premiumInfoPanel.getLeft() + ((float)this.premiumInfoPanel.getWidth() - (float)font.width((FormattedText)premiumName) * scale) / 2.0f) / scale);
        y = (int)(((float)this.premiumInfoPanel.getTop() - 10.0f * scale) / scale);
        graphics.drawString(font, premiumName, x, y, 0xFFFFFF);
        x = (int)(((float)this.budgetInfoPanel.getLeft() + ((float)this.budgetInfoPanel.getWidth() - (float)font.width((FormattedText)budgetName) * scale) / 2.0f) / scale);
        y = (int)(((float)this.budgetInfoPanel.getTop() - 10.0f * scale) / scale);
        graphics.drawString(font, budgetName, x, y, 0xFFFFFF);
        graphics.pose().popPose();
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.setStep(new SelectJarStep(this.orderData));
    }
}

