/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public final class JsonUtils {
    private static final Gson GSON = new Gson();

    private JsonUtils() {
    }

    public static <T extends JsonElement> T readFromFile(Path path, Class<T> clazz) throws IOException {
        BufferedReader reader = Files.newBufferedReader(path);
        return (T)((JsonElement)GSON.fromJson((Reader)reader, clazz));
    }

    public static <T extends JsonElement> T safeReadFromFile(Path path, T defaultValue) {
        try {
            return JsonUtils.readFromFile(path, (Class)Utils.cast(defaultValue.getClass()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends JsonElement> T readFromString(String jsonString, Class<T> clazz) {
        return (T)((JsonElement)GSON.fromJson(jsonString, clazz));
    }

    public static JsonArray arrayOrSelf(@Nullable JsonElement element) {
        if (element == null) {
            return new JsonArray();
        }
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        JsonArray array = new JsonArray();
        array.add(element);
        return array;
    }

    public static <T extends JsonElement> void arrayForEach(@Nullable JsonElement element, Class<T> filter, Consumer<T> consumer) {
        for (JsonElement e : JsonUtils.arrayOrSelf(element)) {
            if (!filter.isInstance(e)) continue;
            consumer.accept((JsonElement)filter.cast(e));
        }
    }

    public static JsonObject objectOrSelf(@Nullable JsonElement element) {
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            return jsonObject;
        }
        return new JsonObject();
    }

    public static String stringOrSelf(@Nullable JsonElement element) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            return primitive.getAsString();
        }
        return "";
    }

    public static boolean replaceOn(JsonArray jsonArray, UnaryOperator<JsonElement> callback) {
        boolean changed = false;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement result = (JsonElement)callback.apply(jsonArray.get(i));
            if (result == null) continue;
            jsonArray.set(i, result);
            changed = true;
        }
        return changed;
    }

    public static boolean replaceOn(JsonObject jsonObject, String key, UnaryOperator<JsonElement> callback) {
        JsonElement element = jsonObject.get(key);
        if (element == null) {
            return false;
        }
        JsonElement result = (JsonElement)callback.apply(element);
        if (result != null) {
            jsonObject.add(key, result);
            return true;
        }
        return false;
    }

    public static JsonArray toArray(Iterable<String> list) {
        JsonArray array = new JsonArray();
        list.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    public static List<String> toList(JsonArray array) {
        return StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsString).toList();
    }

    public static <K, V> Map<K, V> deserializeMap(JsonObject json, String key, Function<Map.Entry<String, JsonElement>, K> keyMapper, Function<Map.Entry<String, JsonElement>, V> valueMapper) {
        return json.getAsJsonObject(key).entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper, (a, b) -> b, HashMap::new));
    }

    public static <K, V> Map<K, Set<V>> deserializeMapSet(JsonObject json, String key, Function<Map.Entry<String, JsonElement>, K> keyMapper, Function<String, V> valueMapper) {
        return JsonUtils.deserializeMap(json, key, keyMapper, e -> JsonUtils.toList(((JsonElement)e.getValue()).getAsJsonArray()).stream().map(valueMapper).collect(Collectors.toSet()));
    }
}

