/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.util;

import de.cech12.bucketlib.api.BucketLibComponents;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.mixin.LivingEntityAccessor;
import de.cech12.bucketlib.platform.Services;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BucketLibUtil {
    public static final ResourceLocation MILK_LOCATION = ResourceLocation.withDefaultNamespace((String)"milk");

    private BucketLibUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean notCreative(Entity entity) {
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (player.getAbilities().instabuild) return false;
        return true;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return !BucketLibUtil.containsFluid(itemStack) && !BucketLibUtil.containsMilk(itemStack) && !BucketLibUtil.containsEntityType(itemStack) && !BucketLibUtil.containsBlock(itemStack);
    }

    public static ItemStack createEmptyResult(ItemStack initialStack, Player player, ItemStack resultStack, InteractionHand hand) {
        return BucketLibUtil.createEmptyResult(initialStack, player, resultStack, hand, false);
    }

    public static ItemStack createEmptyResult(ItemStack initialStack, Player player, ItemStack resultStack, InteractionHand hand, boolean addAdditionalBucketOnInstaBuild) {
        if (!BucketLibUtil.notCreative((Entity)player)) {
            if (addAdditionalBucketOnInstaBuild && !player.getInventory().contains(resultStack)) {
                player.getInventory().add(resultStack);
            }
            return initialStack;
        }
        if (resultStack.isEmpty()) {
            if (!initialStack.isEmpty()) {
                if (!player.isSilent()) {
                    player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_BREAK, player.getSoundSource(), 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f, false);
                }
                ((LivingEntityAccessor)player).bucketlib_spawnItemParticles(initialStack, 5);
            }
            player.awardStat(Stats.ITEM_BROKEN.get((Object)initialStack.getItem()));
        }
        return resultStack;
    }

    public static void damageByOne(ItemStack stack, ServerLevel level, Player player) {
        if (level == null) {
            BucketLibUtil.damageByOne(stack, player instanceof ServerPlayer ? (ServerPlayer)player : null);
            return;
        }
        if (!stack.isEmpty() && stack.isDamageableItem() && !BucketLibUtil.isAffectedByInfinityEnchantment(stack)) {
            stack.hurtAndBreak(1, level, player instanceof ServerPlayer ? (ServerPlayer)player : null, item -> stack.setDamageValue(0));
        }
    }

    @Deprecated
    public static void damageByOne(ItemStack stack, @Nullable ServerPlayer player) {
        if (!stack.isEmpty() && stack.isDamageableItem() && !BucketLibUtil.isAffectedByInfinityEnchantment(stack)) {
            int newDamageValue = stack.getDamageValue() + 1;
            if (player != null) {
                CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(player, stack, newDamageValue);
            }
            stack.setDamageValue(newDamageValue);
            if (newDamageValue >= stack.getMaxDamage()) {
                stack.shrink(1);
                stack.setDamageValue(0);
            }
        }
    }

    public static boolean isAffectedByInfinityEnchantment(@Nonnull ItemStack itemStack) {
        if (!Services.CONFIG.isInfinityEnchantmentEnabled()) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucket = (UniversalBucketItem)item;
            Fluid fluid = BucketLibUtil.getFluid(itemStack);
            return fluid != Fluids.EMPTY && fluid.defaultFluidState().is(BucketLibTags.Fluids.INFINITY_ENCHANTABLE) && EnchantmentHelper.getItemEnchantmentLevel((Holder)((HolderLookup.RegistryLookup)VanillaRegistries.createLookup().lookup(Registries.ENCHANTMENT).get()).getOrThrow(Enchantments.INFINITY), (ItemStack)itemStack) > 0 && bucket.canHoldFluid(fluid);
        }
        return false;
    }

    private static boolean containsTagContent(ItemStack itemStack, String tagName) {
        CustomData customdata = (CustomData)itemStack.getOrDefault(BucketLibComponents.BUCKET_CONTENT, (Object)CustomData.EMPTY);
        return customdata.contains(tagName);
    }

    private static String getTagContent(ItemStack itemStack, String tagName) {
        CustomData customdata = (CustomData)itemStack.getOrDefault(BucketLibComponents.BUCKET_CONTENT, (Object)CustomData.EMPTY);
        if (customdata.contains(tagName)) {
            return customdata.copyTag().getString(tagName);
        }
        return null;
    }

    private static ItemStack setTagContent(ItemStack itemStack, String tagName, String tagContent) {
        ItemStack result = itemStack.copy();
        CustomData customdata = (CustomData)result.getOrDefault(BucketLibComponents.BUCKET_CONTENT, (Object)CustomData.EMPTY);
        CompoundTag nbt = customdata.copyTag();
        nbt.putString(tagName, tagContent);
        result.set(BucketLibComponents.BUCKET_CONTENT, (Object)CustomData.of((CompoundTag)nbt));
        return result;
    }

    private static ItemStack removeTagContentNoCopy(ItemStack itemStack, String tagName) {
        CustomData customdata = (CustomData)itemStack.getOrDefault(BucketLibComponents.BUCKET_CONTENT, (Object)CustomData.EMPTY);
        CompoundTag nbt = customdata.copyTag();
        if (nbt.contains(tagName)) {
            nbt.remove(tagName);
            if (nbt.isEmpty()) {
                itemStack.remove(BucketLibComponents.BUCKET_CONTENT);
            } else {
                itemStack.set(BucketLibComponents.BUCKET_CONTENT, (Object)CustomData.of((CompoundTag)nbt));
            }
        }
        return itemStack;
    }

    private static ItemStack removeTagContent(ItemStack itemStack, String tagName) {
        return BucketLibUtil.removeTagContentNoCopy(itemStack.copy(), tagName);
    }

    public static boolean containsContent(ItemStack itemStack) {
        return BucketLibUtil.containsTagContent(itemStack, "BucketContent");
    }

    public static ResourceLocation getContent(ItemStack itemStack) {
        String content = BucketLibUtil.getContentString(itemStack);
        if (content != null) {
            return ResourceLocation.parse((String)content);
        }
        return null;
    }

    public static String getContentString(ItemStack itemStack) {
        return BucketLibUtil.getTagContent(itemStack, "BucketContent");
    }

    public static ItemStack addContent(ItemStack itemStack, ResourceLocation content) {
        return BucketLibUtil.setTagContent(itemStack, "BucketContent", content.toString());
    }

    public static void removeContentNoCopy(ItemStack itemStack, ServerLevel level, @Nullable Player player, boolean damage) {
        ItemStack emptyStack = BucketLibUtil.removeTagContentNoCopy(itemStack, "BucketContent");
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack, level, player);
        }
    }

    private static ItemStack removeContent(ItemStack itemStack, ServerLevel level, @Nullable Player player, boolean damage) {
        ItemStack emptyStack = BucketLibUtil.removeTagContent(itemStack, "BucketContent");
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack, level, player);
        }
        return emptyStack;
    }

    public static boolean containsMilk(ItemStack itemStack) {
        ResourceLocation bucketContent = BucketLibUtil.getContent(itemStack);
        if (bucketContent != null && bucketContent.equals((Object)MILK_LOCATION)) {
            return true;
        }
        if (Services.FLUID.hasMilkFluid()) {
            return BucketLibUtil.getFluid(itemStack) == Services.FLUID.getMilkFluid();
        }
        return false;
    }

    public static ItemStack addMilk(ItemStack itemStack) {
        ItemStack filledStack = itemStack;
        if (Services.FLUID.hasMilkFluid()) {
            filledStack = BucketLibUtil.addFluid(filledStack, Services.FLUID.getMilkFluid());
        }
        return BucketLibUtil.addContent(filledStack, MILK_LOCATION);
    }

    public static ItemStack removeMilk(ItemStack itemStack, ServerLevel level, @Nullable Player player) {
        return BucketLibUtil.removeFluid(itemStack, level, player);
    }

    public static boolean containsFluid(ItemStack itemStack) {
        return BucketLibUtil.getFluid(itemStack) != Fluids.EMPTY;
    }

    public static Fluid getFluid(ItemStack itemStack) {
        return Services.FLUID.getContainedFluid(itemStack);
    }

    public static ItemStack addFluid(ItemStack itemStack, Fluid fluid) {
        return Services.FLUID.addFluid(itemStack, fluid);
    }

    public static ItemStack removeFluid(ItemStack itemStack, ServerLevel level, @Nullable Player player) {
        AtomicReference<ItemStack> resultItemStack = new AtomicReference<ItemStack>(itemStack.copy());
        if (BucketLibUtil.containsMilk(itemStack)) {
            resultItemStack.set(BucketLibUtil.removeContent(resultItemStack.get(), level, player, !BucketLibUtil.containsFluid(resultItemStack.get())));
        }
        return Services.FLUID.removeFluid(resultItemStack.get(), level, player);
    }

    public static boolean containsEntityType(ItemStack itemStack) {
        return BucketLibUtil.containsTagContent(itemStack, "EntityType");
    }

    public static EntityType<?> getEntityType(ItemStack itemStack) {
        String content = BucketLibUtil.getEntityTypeString(itemStack);
        if (content != null) {
            return Services.REGISTRY.getEntityType(ResourceLocation.parse((String)content));
        }
        return null;
    }

    public static String getEntityTypeString(ItemStack itemStack) {
        return BucketLibUtil.getTagContent(itemStack, "EntityType");
    }

    public static ItemStack addEntityType(ItemStack itemStack, EntityType<?> entityType) {
        return BucketLibUtil.setTagContent(itemStack, "EntityType", Services.REGISTRY.getEntityTypeLocation(entityType).toString());
    }

    public static ItemStack removeEntityType(ItemStack itemStack, ServerLevel level, @Nullable Player player, boolean damage) {
        ItemStack emptyStack = BucketLibUtil.removeTagContent(itemStack, "EntityType");
        emptyStack.remove(DataComponents.BUCKET_ENTITY_DATA);
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack, level, player);
        }
        return emptyStack;
    }

    public static boolean containsBlock(ItemStack itemStack) {
        return BucketLibUtil.containsContent(itemStack) && !BucketLibUtil.containsMilk(itemStack);
    }

    public static Block getBlock(ItemStack itemStack) {
        ResourceLocation content;
        if (!BucketLibUtil.containsMilk(itemStack) && (content = BucketLibUtil.getContent(itemStack)) != null) {
            return Services.REGISTRY.getBlock(content);
        }
        return null;
    }

    public static ItemStack addBlock(ItemStack itemStack, Block block) {
        ResourceLocation blockLocation = Services.REGISTRY.getBlockLocation(block);
        if (blockLocation != null) {
            return BucketLibUtil.addContent(itemStack, blockLocation);
        }
        return itemStack.copy();
    }

    public static ItemStack removeBlock(ItemStack itemStack, ServerLevel level, @Nullable Player player, boolean damage) {
        if (!BucketLibUtil.containsMilk(itemStack)) {
            return BucketLibUtil.removeContent(itemStack, level, player, damage);
        }
        return itemStack.copy();
    }
}

