/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.common.util.Restriction;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;

public class Range<T extends Comparable<T>> {
    @Nullable
    private final List<Restriction<T>> restrictions;

    public Range(@Nullable List<Restriction<T>> restrictions) {
        this.restrictions = restrictions;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.restrictions == null) {
            return buf.toString();
        }
        Iterator<Restriction<T>> i = this.restrictions.iterator();
        while (i.hasNext()) {
            Restriction<T> r = i.next();
            buf.append(r.toString());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    @Nullable
    public T match(List<T> things) {
        Comparable matched = null;
        for (Comparable thing : things) {
            if (!this.contains(thing) || matched != null && thing.compareTo(matched) <= 0) continue;
            matched = thing;
        }
        return (T)matched;
    }

    public boolean contains(T thing) {
        if (this.restrictions == null) {
            return false;
        }
        for (Restriction<T> restriction : this.restrictions) {
            if (!restriction.contains(thing)) continue;
            return true;
        }
        return false;
    }

    public String toFormattedString() {
        StringBuilder buf = new StringBuilder();
        if (this.restrictions == null) {
            return buf.toString();
        }
        Iterator<Restriction<T>> i = this.restrictions.iterator();
        while (i.hasNext()) {
            Restriction<T> r = i.next();
            buf.append(r.toFormattedString());
            if (!i.hasNext()) continue;
            buf.append(" or ");
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range range = (Range)obj;
        return Objects.equals(this.restrictions, range.restrictions);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return hash;
    }

    @Nullable
    @Generated
    public List<Restriction<T>> getRestrictions() {
        return this.restrictions;
    }
}

