/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class CycleTimer {
    private final Supplier<Integer> cycleTime;
    private final boolean ignoreShift;
    private long startTime;
    private long drawTime;
    private long pausedDuration = 0L;

    public CycleTimer(Supplier<Integer> cycleTime, boolean ignoreShift) {
        this.cycleTime = cycleTime;
        long time = System.currentTimeMillis();
        this.startTime = time - (long)cycleTime.get().intValue();
        this.drawTime = time;
        this.ignoreShift = ignoreShift;
    }

    @Nullable
    public <T> T get(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        long index = (this.drawTime - this.startTime) / (long)this.cycleTime.get().intValue() % (long)list.size();
        return list.get(Math.toIntExact(index));
    }

    public <T> T getOrDefault(List<T> list, T defaultObject) {
        return Optional.ofNullable(this.get(list)).orElse(defaultObject);
    }

    public void onDraw() {
        if (this.ignoreShift) {
            if (this.pausedDuration > 0L) {
                this.startTime += this.pausedDuration;
                this.pausedDuration = 0L;
            }
            this.drawTime = System.currentTimeMillis();
        } else if (!Screen.hasShiftDown()) {
            if (this.pausedDuration > 0L) {
                this.startTime += this.pausedDuration;
                this.pausedDuration = 0L;
            }
            this.drawTime = System.currentTimeMillis();
        } else {
            this.pausedDuration = System.currentTimeMillis() - this.drawTime;
        }
    }

    @Generated
    public Supplier<Integer> getCycleTime() {
        return this.cycleTime;
    }
}

