/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.common.entity.ChunkloaderEntity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.ChunkPos;

public class ChunkloaderList {
    private static final List<WeakReference<ChunkloaderEntity>> LOADED_MACHINES = Collections.synchronizedList(Lists.newArrayList());

    private ChunkloaderList() {
    }

    public static void add(ChunkloaderEntity tile) {
        if (tile.getLevel() != null && !tile.getLevel().isClientSide()) {
            LOADED_MACHINES.add(new WeakReference<ChunkloaderEntity>(tile));
        }
    }

    public static Optional<ChunkloaderEntity> findInSameChunk(ChunkloaderEntity machine) {
        return ChunkloaderList.getLoadedMachines().stream().filter(tile -> tile != machine && tile.getLevel() == machine.getLevel() && new ChunkPos(tile.getBlockPos()).equals((Object)new ChunkPos(machine.getBlockPos()))).findFirst();
    }

    public static List<ChunkloaderEntity> getLoadedMachines() {
        Iterator<WeakReference<ChunkloaderEntity>> iterator = LOADED_MACHINES.iterator();
        ArrayList loadedMachines = Lists.newArrayList();
        while (iterator.hasNext()) {
            ChunkloaderEntity tile = (ChunkloaderEntity)iterator.next().get();
            if (tile == null || tile.isRemoved()) {
                iterator.remove();
                continue;
            }
            loadedMachines.add(tile);
        }
        return loadedMachines;
    }
}

