/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.server;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SUpdateMachineTexturePacket(ResourceLocation texture, boolean base, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SUpdateMachineTexturePacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("update_machine_texture"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SUpdateMachineTexturePacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SUpdateMachineTexturePacket::texture, (StreamCodec)ByteBufCodecs.BOOL, SUpdateMachineTexturePacket::base, (StreamCodec)BlockPos.STREAM_CODEC, SUpdateMachineTexturePacket::pos, SUpdateMachineTexturePacket::new);

    public CustomPacketPayload.Type<SUpdateMachineTexturePacket> type() {
        return TYPE;
    }

    public static void handle(SUpdateMachineTexturePacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                BlockEntity be = context.player().level().getBlockEntity(packet.pos);
                if (be instanceof TextureableMachineEntity) {
                    TextureableMachineEntity entity = (TextureableMachineEntity)be;
                    if (packet.base) {
                        entity.setMachineBaseTexture(packet.texture);
                    } else {
                        entity.setMachineOverlayTexture(packet.texture);
                    }
                    be.requestModelDataUpdate();
                    context.player().level().setBlockAndUpdate(be.getBlockPos(), be.getBlockState());
                    be.setChanged();
                }
            });
        }
    }
}

