/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.client;

import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.experiencelib.util.ExperienceUtils;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.screen.widget.ExperienceButtonType;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CExperienceButtonClickedPacket(BlockPos entityPos, ExperienceButtonType amount, boolean extraction) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CExperienceButtonClickedPacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("experience_button_clicked"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CExperienceButtonClickedPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, CExperienceButtonClickedPacket>(){

        public CExperienceButtonClickedPacket decode(RegistryFriendlyByteBuf buffer) {
            return new CExperienceButtonClickedPacket(buffer.readBlockPos(), (ExperienceButtonType)buffer.readEnum(ExperienceButtonType.class), buffer.readBoolean());
        }

        public void encode(RegistryFriendlyByteBuf buffer, CExperienceButtonClickedPacket value) {
            buffer.writeBlockPos(value.entityPos);
            buffer.writeEnum((Enum)value.amount);
            buffer.writeBoolean(value.extraction);
        }
    };

    public CustomPacketPayload.Type<CExperienceButtonClickedPacket> type() {
        return TYPE;
    }

    public static void handle(CExperienceButtonClickedPacket packet, IPayloadContext context) {
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player2 = (player = (ServerPlayer)player2).level().getBlockEntity(packet.entityPos)) instanceof ExperienceHatchEntity) {
            ExperienceHatchEntity entity = (ExperienceHatchEntity)player2;
            if (packet.amount.isAll()) {
                ExperienceUtils.addAllLevelToPlayer((IExperienceHandler)entity.getTank(), (boolean)packet.extraction, (Player)player);
            } else {
                ExperienceUtils.addLevelToPlayer((IExperienceHandler)entity.getTank(), (int)packet.amount.getAmount(packet.extraction), (Player)player);
            }
        }
    }
}

