/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager.crafting;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.api.crafting.CraftingContext;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.BooleanSyncable;
import es.degrassi.mmreborn.api.network.syncable.FloatSyncable;
import es.degrassi.mmreborn.api.network.syncable.IntegerSyncable;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessor;
import es.degrassi.mmreborn.common.manager.crafting.MachineRecipeFinder;
import es.degrassi.mmreborn.common.manager.crafting.Phase;
import es.degrassi.mmreborn.common.manager.crafting.RequirementList;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class MachineProcessorCore
implements ISyncableStuff {
    private final MachineProcessor processor;
    private final MachineControllerEntity tile;
    private final RandomSource rand = Utils.RAND;
    private final MachineRecipeFinder recipeFinder;
    private boolean active = false;
    @Nullable
    private RecipeHolder<MachineRecipe> currentRecipe;
    private ResourceLocation futureRecipeID;
    private CraftingContext context;
    private float recipeProgressTime;
    private int recipeTotalTime = 0;
    private boolean searchImmediately = false;
    private Phase phase = Phase.CONDITIONS;
    private boolean componentChanged = false;
    @Nullable
    private Component error = null;
    private boolean isLastRecipeTick = false;
    private boolean hasActiveRecipe;
    private RequirementList<MachineComponent<?>> requirementList;
    private final List<RequirementList.RequirementWithFunction> currentProcessRequirements = Lists.newArrayList();
    private int core;

    public MachineProcessorCore(MachineProcessor processor, MachineControllerEntity tile, int core) {
        this.processor = processor;
        this.tile = tile;
        this.recipeFinder = new MachineRecipeFinder(tile, new CraftingContext.Mutable(tile, core - 1), this);
        this.core = core;
    }

    public int getCore() {
        return this.processor.cores().indexOf(this) + 1;
    }

    public float getRecipeTotalTime() {
        return this.recipeTotalTime;
    }

    public void init() {
        if (this.isActive() && this.futureRecipeID != null && this.tile.getLevel() != null) {
            this.tile.getLevel().getRecipeManager().byKey(this.futureRecipeID).filter(holder -> holder.value() instanceof MachineRecipe).map(holder -> holder).ifPresent(recipe -> {
                this.setRecipe((RecipeHolder<MachineRecipe>)recipe);
                this.requirementList.getProcessRequirements().entrySet().removeIf(entry -> (Double)entry.getKey() < (double)(this.recipeProgressTime / (float)this.recipeTotalTime));
            });
            this.futureRecipeID = null;
            this.tile.getComponentManager().updateComponents(true);
        }
        this.recipeFinder.init();
    }

    public boolean hasActiveRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public void tick() {
        if (!this.isActive()) {
            return;
        }
        if (this.currentRecipe == null) {
            this.recipeFinder.findRecipe(this.searchImmediately).ifPresent(this::setRecipe);
            this.searchImmediately = false;
            this.componentChanged = false;
        }
        if (this.currentRecipe != null) {
            this.tile.checkStructure(true);
            if (this.tile.getStatus().isMissingStructure()) {
                this.processor.reset();
                return;
            }
            if (this.phase == Phase.CONDITIONS) {
                this.checkConditions();
            }
            if (this.phase == Phase.PROCESS) {
                this.processRequirements();
            }
            if (this.phase == Phase.PROCESS_TICK) {
                this.processTickRequirements();
            }
            if (this.currentRecipe != null && this.error == null && this.recipeProgressTime >= (float)this.recipeTotalTime - this.context.getModifiedSpeed()) {
                if (this.isLastRecipeTick) {
                    this.isLastRecipeTick = false;
                    this.reset();
                    this.recipeFinder.findRecipe(true).ifPresent(this::setRecipe);
                } else {
                    this.isLastRecipeTick = true;
                }
            }
        }
    }

    private void checkConditions() {
        CraftingResult result;
        if (this.componentChanged) {
            this.componentChanged = false;
            for (RequirementList.RequirementWithFunction requirement : this.requirementList.getInventoryConditions()) {
                result = requirement.process(this.tile.getComponentManager(), this.context);
                if (result.isSuccess()) continue;
                if (this.currentRecipe != null && ((MachineRecipe)this.currentRecipe.value()).isVoidPerTickFailure()) {
                    this.reset();
                } else {
                    this.setError(result.getMessage());
                }
                return;
            }
        }
        for (RequirementList.RequirementWithFunction requirement : this.requirementList.getWorldConditions()) {
            result = requirement.process(this.tile.getComponentManager(), this.context);
            if (result.isSuccess()) continue;
            if (this.currentRecipe != null && ((MachineRecipe)this.currentRecipe.value()).isVoidPerTickFailure()) {
                this.reset();
            } else {
                this.setError(result.getMessage());
            }
            return;
        }
        this.setRunning();
        this.phase = Phase.PROCESS;
    }

    private void processRequirements() {
        if (this.currentProcessRequirements.isEmpty()) {
            this.requirementList.getProcessRequirements().entrySet().removeIf(entry -> {
                if ((Double)entry.getKey() <= (double)(this.recipeProgressTime / (float)this.recipeTotalTime) || this.isLastRecipeTick) {
                    this.currentProcessRequirements.addAll((Collection)entry.getValue());
                    return true;
                }
                return false;
            });
        }
        Iterator<RequirementList.RequirementWithFunction> iterator = this.currentProcessRequirements.iterator();
        while (iterator.hasNext()) {
            CraftingResult result;
            RequirementList.RequirementWithFunction requirement = iterator.next();
            if (!requirement.requirement().shouldSkip(this.rand, this.context) && !(result = requirement.process(this.tile.getComponentManager(), this.context)).isSuccess()) {
                if (this.currentRecipe != null && ((MachineRecipe)this.currentRecipe.value()).isVoidPerTickFailure()) {
                    this.reset();
                } else {
                    this.setError(result.getMessage());
                }
                return;
            }
            iterator.remove();
        }
        this.setRunning();
        this.phase = Phase.PROCESS_TICK;
    }

    private void processTickRequirements() {
        if (this.currentProcessRequirements.isEmpty()) {
            this.currentProcessRequirements.addAll(this.requirementList.getTickableRequirements());
        }
        Iterator<RequirementList.RequirementWithFunction> iterator = this.currentProcessRequirements.iterator();
        while (iterator.hasNext()) {
            CraftingResult result;
            RequirementList.RequirementWithFunction requirement = iterator.next();
            if (!requirement.requirement().shouldSkip(this.rand, this.context) && !(result = requirement.process(this.tile.getComponentManager(), this.context)).isSuccess()) {
                if (this.currentRecipe != null && ((MachineRecipe)this.currentRecipe.value()).isVoidPerTickFailure()) {
                    this.reset();
                } else {
                    this.setError(result.getMessage());
                }
                return;
            }
            iterator.remove();
        }
        this.setRunning();
        this.phase = Phase.CONDITIONS;
        this.recipeProgressTime += this.context.getModifiedSpeed();
    }

    private void setRecipe(@NotNull RecipeHolder<MachineRecipe> recipe) {
        this.currentRecipe = recipe;
        this.context = new CraftingContext(this.tile, recipe, () -> Float.valueOf(this.recipeProgressTime), this.processor.cores().indexOf(this));
        this.recipeTotalTime = ((MachineRecipe)this.currentRecipe.value()).getRecipeTotalTickTime();
        this.requirementList = new RequirementList();
        ((MachineRecipe)this.currentRecipe.value()).getRequirements().forEach(requirement -> {
            this.requirementList.setCurrentRequirement((RecipeRequirement<MachineComponent<?>, ?>)requirement);
            requirement.requirement().gatherRequirements(this.requirementList);
        });
        this.phase = Phase.CONDITIONS;
    }

    private void setRunning() {
        this.error = null;
        this.processor.setRunning();
    }

    private void setError(Component error) {
        this.error = error;
        this.processor.setError(error);
    }

    public void reset() {
        this.currentRecipe = null;
        this.futureRecipeID = null;
        this.recipeProgressTime = 0.0f;
        this.recipeTotalTime = 0;
        this.requirementList = null;
        this.context = null;
        this.phase = Phase.CONDITIONS;
        this.currentProcessRequirements.clear();
    }

    public void setSearchImmediately() {
        if (this.currentRecipe == null) {
            this.searchImmediately = true;
        }
    }

    public void setComponentChanged() {
        this.recipeFinder.setComponentChanged(true);
        this.componentChanged = true;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("active", this.active);
        nbt.putInt("core", this.core);
        if (this.currentRecipe != null) {
            nbt.putString("recipe", this.currentRecipe.id().toString());
        }
        nbt.putString("phase", this.phase.toString());
        nbt.putFloat("recipeProgressTime", this.recipeProgressTime);
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        this.active = nbt.getBoolean("active");
        this.core = nbt.getInt("core");
        if (nbt.contains("recipe", 8)) {
            this.futureRecipeID = ResourceLocation.parse((String)nbt.getString("recipe"));
        }
        if (nbt.contains("phase", 8)) {
            this.phase = Phase.valueOf(nbt.getString("phase"));
        }
        if (nbt.contains("recipeProgressTime", 6)) {
            this.recipeProgressTime = nbt.getFloat("recipeProgressTime");
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(BooleanSyncable.create(() -> this.active, active -> {
            this.active = active;
        }));
        container.accept(IntegerSyncable.create(() -> this.core, core -> {
            this.core = core;
        }));
        container.accept(FloatSyncable.create(() -> Float.valueOf(this.recipeProgressTime), recipeProgressTime -> {
            this.recipeProgressTime = recipeProgressTime.floatValue();
        }));
        container.accept(IntegerSyncable.create(() -> this.recipeTotalTime, recipeTotalTime -> {
            this.recipeTotalTime = recipeTotalTime;
        }));
        container.accept(BooleanSyncable.create(() -> this.getCurrentRecipe() != null, hasActiveRecipe -> {
            this.hasActiveRecipe = hasActiveRecipe;
        }));
    }

    public float getCurrentActiveRecipeProgress() {
        return this.getRecipeProgressTime() / this.getRecipeTotalTime();
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Nullable
    @Generated
    public RecipeHolder<MachineRecipe> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Generated
    public float getRecipeProgressTime() {
        return this.recipeProgressTime;
    }

    @Nullable
    @Generated
    public Component getError() {
        return this.error;
    }

    @Generated
    public boolean isHasActiveRecipe() {
        return this.hasActiveRecipe;
    }
}

