/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.item;

import es.degrassi.mmreborn.common.registration.DataComponentRegistration;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface ItemHatch {
    public ResourceLocation getDefaultBaseTexture();

    public ResourceLocation getDefaultOverlayTexture();

    @Nullable
    public static ResourceLocation getBaseTexture(ItemStack stack) {
        if (!stack.has(DataComponentRegistration.BASE_TEXTURE)) {
            return null;
        }
        return (ResourceLocation)stack.get(DataComponentRegistration.BASE_TEXTURE);
    }

    @Nullable
    public static ResourceLocation getOverlayTexture(ItemStack stack) {
        if (!stack.has(DataComponentRegistration.OVERLAY_TEXTURE)) {
            return null;
        }
        return (ResourceLocation)stack.get(DataComponentRegistration.OVERLAY_TEXTURE);
    }

    public static void resetToDefault(ItemStack stack) {
        ItemHatch.resetBaseTexture(stack);
        ItemHatch.resetOverlayTexture(stack);
    }

    public static void resetBaseTexture(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ItemHatch) {
            ItemHatch item2 = (ItemHatch)item;
            stack.set(DataComponentRegistration.BASE_TEXTURE, (Object)item2.getDefaultBaseTexture());
        }
    }

    public static void resetOverlayTexture(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ItemHatch) {
            ItemHatch item2 = (ItemHatch)item;
            stack.set(DataComponentRegistration.OVERLAY_TEXTURE, (Object)item2.getDefaultOverlayTexture());
        }
    }

    public static void setBaseTexture(ItemStack stack, ResourceLocation texture) {
        stack.set(DataComponentRegistration.BASE_TEXTURE, (Object)texture);
    }

    public static void setOverlayTexture(ItemStack stack, ResourceLocation texture) {
        stack.set(DataComponentRegistration.OVERLAY_TEXTURE, (Object)texture);
    }
}

