/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.theoneprobe.element;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.integration.theoneprobe.element.CustomProgressRenderer;
import es.degrassi.mmreborn.common.util.Utils;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;

public class CustomProgress
implements IElement {
    public static final ResourceLocation ID = ModularMachineryReborn.rl("progress");
    private final float current;
    private final float max;
    private final IProgressStyle style;

    public CustomProgress(float current, float max, IProgressStyle style) {
        this.current = current;
        this.max = max;
        this.style = style;
    }

    public CustomProgress(RegistryFriendlyByteBuf buf) {
        this.current = buf.readFloat();
        this.max = buf.readFloat();
        this.style = new ProgressStyle().width(buf.readInt()).height(buf.readInt()).prefix((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf)).suffix((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf)).borderColor(buf.readInt()).filledColor(buf.readInt()).alternateFilledColor(buf.readInt()).backgroundColor(buf.readInt()).showText(buf.readBoolean()).numberFormat(NumberFormat.values()[buf.readByte()]).lifeBar(buf.readBoolean()).armorBar(buf.readBoolean()).alignment((ElementAlignment)buf.readEnum(ElementAlignment.class));
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        CustomProgressRenderer.render(this.style, this.current, this.max, guiGraphics, x, y, this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        if (this.style.isLifeBar()) {
            return this.current * 4.0f >= (float)this.style.getWidth() ? 100 : (int)(this.current * 4.0f + 2.0f);
        }
        return this.style.getWidth();
    }

    public int getHeight() {
        return this.style.getHeight();
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeFloat(this.current);
        buf.writeFloat(this.max);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.style.getPrefixComp());
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.style.getSuffixComp());
        buf.writeInt(this.style.getBorderColor());
        buf.writeInt(this.style.getFilledColor());
        buf.writeInt(this.style.getAlternatefilledColor());
        buf.writeInt(this.style.getBackgroundColor());
        buf.writeBoolean(this.style.isShowText());
        buf.writeByte(this.style.getNumberFormat().ordinal());
        buf.writeBoolean(this.style.isLifeBar());
        buf.writeBoolean(this.style.isArmorBar());
        buf.writeEnum((Enum)this.style.getAlignment());
    }

    public ResourceLocation getID() {
        return ID;
    }

    public static Component format(float in, float max, NumberFormat style, Component suffix) {
        float i = max >= 20.0f ? in / 20.0f : in;
        switch (style) {
            case FULL: 
            case COMMAS: {
                return Component.literal((String)Utils.decimalFormat(i)).append(suffix);
            }
            case COMPACT: {
                if (i < 1000.0f) {
                    return Component.literal((String)(i + " ")).append(suffix);
                }
                int unit = 1000;
                int exp = (int)(Math.log(i) / Math.log(unit));
                String s = suffix.getString();
                if (s.startsWith("m")) {
                    s = s.substring(1);
                    if (exp - 2 >= 0) {
                        char pre = "kMGTPE".charAt(exp - 2);
                        return Component.literal((String)String.format("%.1f %s", (double)i / Math.pow(unit, exp), Character.valueOf(pre))).append((Component)Component.literal((String)s).withStyle(suffix.getStyle()));
                    }
                    return Component.literal((String)String.format("%.1f", (double)i / Math.pow(unit, exp))).append((Component)Component.literal((String)s).withStyle(suffix.getStyle()));
                }
                char pre = "kMGTPE".charAt(exp - 1);
                return Component.literal((String)String.format("%.1f %s", (double)i / Math.pow(unit, exp), Character.valueOf(pre))).append(suffix);
            }
            case NONE: {
                return suffix;
            }
        }
        return Component.literal((String)Float.toString(i));
    }

    public static class CustomProgressFactory
    implements IElementFactory {
        public CustomProgress createElement(RegistryFriendlyByteBuf buffer) {
            return new CustomProgress(buffer);
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

