/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.requirement;

import es.degrassi.mmreborn.api.FluidIngredient;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFluid;
import es.degrassi.mmreborn.common.integration.kubejs.MachineRecipeBuilderJS;
import es.degrassi.mmreborn.common.integration.kubejs.RecipeJSBuilder;
import es.degrassi.mmreborn.common.machine.IOType;
import net.neoforged.neoforge.fluids.FluidStack;

public interface FluidRequirementJS
extends RecipeJSBuilder {
    default public MachineRecipeBuilderJS requireFluid(FluidStack stack, int x, int y) {
        return this.requireFluid(stack, 1.0f, x, y);
    }

    default public MachineRecipeBuilderJS produceFluid(FluidStack stack, int x, int y) {
        return this.produceFluid(stack, 1.0f, x, y);
    }

    default public MachineRecipeBuilderJS requireFluid(FluidStack stack) {
        return this.requireFluid(stack, 1.0f, 0, 0);
    }

    default public MachineRecipeBuilderJS produceFluid(FluidStack stack) {
        return this.produceFluid(stack, 1.0f, 0, 0);
    }

    default public MachineRecipeBuilderJS requireFluid(FluidStack stack, float chance, int x, int y) {
        if (chance < 0.0f) {
            return this.error("Chance can not bellow 0", new Object[0]);
        }
        if (chance > 1.0f) {
            return this.error("Chance can not be greater than 1", new Object[0]);
        }
        RequirementFluid requirement = new RequirementFluid(IOType.INPUT, new FluidIngredient(stack.getFluid()), stack.getAmount(), new PositionedRequirement(x, y));
        return this.addRequirement(new RecipeRequirement(requirement, chance));
    }

    default public MachineRecipeBuilderJS produceFluid(FluidStack stack, float chance, int x, int y) {
        if (chance < 0.0f) {
            return this.error("Chance can not bellow 0", new Object[0]);
        }
        if (chance > 1.0f) {
            return this.error("Chance can not be greater than 1", new Object[0]);
        }
        RequirementFluid requirement = new RequirementFluid(IOType.OUTPUT, new FluidIngredient(stack.getFluid()), stack.getAmount(), new PositionedRequirement(x, y));
        return this.addRequirement(new RecipeRequirement(requirement, chance));
    }

    default public MachineRecipeBuilderJS requireFluid(FluidStack stack, float chance) {
        return this.requireFluid(stack, chance, 0, 0);
    }

    default public MachineRecipeBuilderJS produceFluid(FluidStack stack, float chance) {
        return this.produceFluid(stack, chance, 0, 0);
    }
}

