/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.builder;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.Structure;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import java.util.List;
import java.util.Map;

public class StructureBuilderJS {
    private final Structure.Builder builder = Structure.Builder.start();
    private List<List<String>> pattern;
    private Map<Character, BlockIngredient> keys;

    public static StructureBuilderJS create() {
        return new StructureBuilderJS();
    }

    public StructureBuilderJS pattern(List<List<String>> pattern) {
        this.pattern = pattern;
        return this;
    }

    public StructureBuilderJS keys(Map<Character, JsonElement> keys) {
        this.keys = Maps.newHashMap();
        keys.forEach((character, s) -> this.keys.put((Character)character, (BlockIngredient)BlockIngredient.CODEC.read(JsonOps.INSTANCE, s).getOrThrow()));
        return this;
    }

    public Structure build(List<ModifierReplacement> modifiers) {
        for (List<String> list : this.pattern) {
            this.builder.aisle(list.toArray(new String[0]));
        }
        for (Map.Entry entry : this.keys.entrySet()) {
            this.builder.where(((Character)entry.getKey()).charValue(), (BlockIngredient)entry.getValue());
        }
        return this.builder.build(this.pattern, this.keys, modifiers);
    }
}

